﻿var rowNum = 0;
var initRow = true;
var curRespRowNum;
var rowIndex;

var inputArray;
var outSlotNo;

var objIdArray = ["port", "outMode", "inCard", "inPort", "rateSwitch", "outRate"];
var COL_NUM = 6;

var OUT_PORT = 0;
var OUTPUT_MODE = 1;
var INPUT_CARD = 2;
var PASS_THROUGH = 0;
var FILTER = 1;
var RATE_DISABLE = 0;
var RATE_ABLE = 0;
var identifyData;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	outSlotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function changePageStatus(obj)
{
	var index = parseInt(obj.attr("id").slice(7), 10);
	if(parseInt(obj.val(), 10) == PASS_THROUGH)
	{
		for(var j = INPUT_CARD; j < COL_NUM; j++)
		{
			$("#" + objIdArray[j] + index).attr("disabled", false);
		}
		if(identifyData == RATE_DISABLE)
		{
			$("#rateSwitch" + index).attr("disabled", true);
			$("#outRate" + index).attr("disabled", true);
		}
	}
	else
	{
		for(var j = INPUT_CARD; j < COL_NUM; j++)
		{
			$("#" + objIdArray[j] + index).attr("disabled", true);
		}
	}

}
function funcUpdateDisplay() 
{		
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	generateOption();
	
	ResetColor();
	PageLoadStatus(false);	
}

function generateOption()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + OUTPUT_LIST + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			inputArray = response.split(FIRST_DELIMITER);
			displayParam();
		}
	}
	xmlHttp.send(null);
}

function displayParam()
{
	var data;
	var response;
	var indexInfo;
	var curRowNum;
	
	var xmlHttp = GetHTTPObject();
	if(initRow)
	{
		rowIndex = 0;		
	}
	xmlHttp.open("GET", "/goform/formEMR30?type=" + OUT_CONFIG + "&cmd=" + GET + "&rowIndex=" + rowIndex + 
		"&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				var timeObj = new Date();
				startRefreshTime = timeObj.getTime();
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 2;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);
				identifyData = data[curRespRowNum + 1];
				curRowNum = $("#dataTable tr").filter(".CaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					DrawTableRow("dataTable", "dataRow", "CaseRow", rowIndex);
				}
				else if(curRowNum > rowNum)
				{
					DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				}
				if(curRespRowNum != 0)
				{
					populateInputCards();
					updateTableData(data);
					for(i = (rowIndex - curRespRowNum); i < rowIndex; i++)
					{
						changePageStatus($("#outMode" + (i + 1)));
					}
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					EnableButton("refreshBtn");
					initRow = true;
					refreshFlag = true;
				}
			}
		}
	}
	xmlHttp.send(null);
}

function populateInputCards()
{
	var inputCard;
	var inputInfo;
	var option;
	var cardNum = inputArray.length;
	for(var i = (rowIndex - curRespRowNum); i < rowIndex; i++)
	{
		inputCard = $("#inCard" + (i + 1));
		inputCard.empty();
		for(var j = 0; j < cardNum; j++) 
		{
			inputInfo = inputArray[j].split(SECOND_DELIMITER);
			//option = $("<option>").text(inputInfo[0]).val(inputInfo[1]);
			//inputCard.append(option);
			inputCard.get(0).options.add(new Option(inputInfo[0], parseInt(inputInfo[1])));
		}
	}
}

function populateInputPorts(obj)
{
	var index = parseInt(obj.attr("id").slice(6), 10);
	var selectIndex = obj.get(0).selectedIndex;
	var inputInfo = inputArray[selectIndex].split(SECOND_DELIMITER);
	var portNum = inputInfo.length - 2;
	var inputPort = $("#inPort" + index);
	//var option;
	var displayStr;
	
	inputPort.empty();
	inputPort.hide(); //先隐藏后显示的修改针对部分IE浏览器下，切换板卡后浏览器显示的端口列表不更新，实际上代码执行完成
	for(var i = 0; i < portNum; i++)
	{	
		displayStr = getPortDisplayStr(parseInt(obj.val(), 10), parseInt(inputInfo[2 + i], 10), language);
		//option = $("<option>").text(displayStr).val(parseInt(inputInfo[2 + i], 10) - 1);
		//inputPort.append(option);
		inputPort.get(0).options.add(new Option(displayStr,parseInt(inputInfo[2 + i], 10) - 1)); //jquery的写法在部分IE浏览器下表现出的问题是，第一次列表的横向长度决定了以后的长度，后面大于第一次长度的字符串都显示不完全
		
	}
	if(inputPort.find("option").length != 0)
	{
		inputPort.val(parseInt(inputInfo[2], 10) - 1);
	}	
	inputPort.show();
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = (rowIndex - curRespRowNum); i < rowIndex; i++)
	{
		index = i + 1;
		rowData = data[i - (rowIndex - curRespRowNum)].split(SECOND_DELIMITER);

		for(var j = 0; j < COL_NUM; j++)
		{
			if(j == OUT_PORT)
			{
				$("#" + objIdArray[j] + index).html(getPortDisplayStr(outSlotNo, parseInt(rowData[j], 10), language));
			}
			else if(j == INPUT_CARD)
			{
				$("#" + objIdArray[j] + index).val(rowData[j]);
				populateInputPorts($("#inCard" + index));
			}
			else
			{
				$("#" + objIdArray[j] + index).val(rowData[j]);
			}
		}
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(initRow == false)
	{
		return;
	}
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + OUT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
	for(var i = 0; i < rowNum; i++)
	{
		if(ValidateParam($("#outRate" + (i + 1)), "INT_DEC", 0, 213000000, "<Output Bitrate>", "<输出码率>", language) == false)
		{
			return false;
		}
	}

	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < rowNum; i++)
	{
		for(var j = OUTPUT_MODE; j < COL_NUM; j++)
		{
			if((i == 0) && (j == OUTPUT_MODE))
			{
				data = $("#" + objIdArray[j] + (i + 1)).val();
			}
			else if((i != 0) && (j == OUTPUT_MODE))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
		}
	}
	
	return data;
}