﻿var objIdArray = ["outPort", "outPid", "backupMode", "workState", "mainCard", "mainPort", "mainDescType", "mainDesc", "mainPid", "backupCard", "backupPort", "backupDescType", "backupDesc", "backupPid"];
var rowNum = 0;
var initRow = true;
var curRespRowNum;
var rowIndex;

var portDataArray = [];
var outSlotNoArray = [];
var outSlotNo;

var OUT_PORT = 0;
var BACKUP_MODE = 2;
var WORK_STATE = 3;
var MAIN_PORT = 5;
var MAIN_DESC_TYPE = 6;
var MAIN_DESC = 7;
var BACKUP_PORT = 10;
var BACKUP_DESC_TYPE = 11;
var BACKUP_DESC = 12;
var SUPPORT_PORT_DESC = 0;

var INVALID = 0;
var MAIN = 1;
var BACKUP = 2;
var workStateEn = ["Invalid", "Main", "Backup"];
var workStateCn = ["无效", "主路", "备路"];
var workState = [workStateEn, workStateCn];

var backupModeEn = ["", "Assign Main", "Assign Backup", "Main Priority", "One Way Switch", "Floating"];
var backupModeCn = ["", "指定主路", "指定备路", "主路优先", "单向切换", "浮动"];
var backupMode = [backupModeEn, backupModeCn];
var OTHER = 7;

var mainMenu = ["Backup", "备份"];
var treeMenu = ["PID Backup", "PID备份"];
var detailMenu = ["Detail Edit", "详细编辑"];
var cardArray = ["Card", "卡"];
var gbeArray = ["GbE", "网口"];
var portArray = ["Port", "端口"];
var progArray = ["Service", "节目"];
var ONE_GBE_PORT_NUM = 256;
var GBE_ONE = 1;
var GBE_TWO = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	outSlotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	
	if(parent.groupAccess != USER)
	{
		$(".all_check, .row_check").live("click", function()
		{
			if(rowNum != 0)
			{
				EnableButton("deleteBtn");
				EnableButton("batchModifyBtn");
			}			
		});
	}
	$("#allApplyCheck").bind("click", function()
	{
		checkAllApply();
	});
	$(".apply_check").bind("click", function()
	{
		var allCheckFlag = true;
		var curCheckStatus = $(this).prop("checked");
		$(".apply_check").each(function()
		{
			if($(this).prop("checked") != curCheckStatus)
			{
				$("#allApplyCheck").prop("checked", false);
				allCheckFlag = false;
			}
			if(allCheckFlag == false)
			{
				return false;
			}
			else
			{
				$("#allApplyCheck").prop("checked", true);
			}
		});
	});
});

function funcUpdateDisplay() 
{		
	DisableButton("batchModifyBtn");
	DisableButton("refreshBtn");
	DisableButton("deleteBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	PageLoadStatus(false);
	$("input[type=checkbox]").prop("checked", false);
}

function checkAll()
{
	for(var i = 0; i < rowNum; i++)
	{
		$("#check" + (i + 1)).prop("checked", $("#checkAll").prop("checked"));
	}
}

function checkAllApply()
{
	$(".apply_check").each(function()
	{
		$(this).prop("checked", $("#allApplyCheck").prop("checked"));
	});
}

function displayParam() 
{
	var data;
	var rowData;
	var response;
	var indexInfo;
	var curRowNum;
	var xmlHttp = GetHTTPObject();
	if(initRow)
	{
		rowIndex = 0;		
	}

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PID_BACKUP_ALL + "&cmd=" + GET + "&rowIndex=" + rowIndex + 
		"&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 1;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);				
				curRowNum = $("#dataTable tr").filter(".mainCaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					DrawTableTwoRow("dataTable", "mainDataRow", "mainCaseRow", "backupDataRow", "backupCaseRow", rowIndex);
				}
				else if(curRowNum > rowNum)
				{
					DrawTableTwoRow("dataTable", "mainDataRow", "mainCaseRow", "backupDataRow", "backupCaseRow", rowNum);
				}
				if(curRespRowNum != 0)
				{
					updateTableData(data);
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					EnableButton("refreshBtn");
					initRow = true;
					refreshFlag = true;
				}
			}
		}
	}
	xmlHttp.send(null);
}

function batchCancel()
{
	$.modal.close();
}

function batchModifyBackup()
{
	$("#batchModifyBackupDiv").modal();
	$("#batchModifyBackupDiv input[type=checkbox]").prop("checked", false);
	for(var i = 0, len = batchParamId.length; i < len; i++)
	{
		if((i < 9) || (i > 12))
		{
			$("#" + batchParamId[i]).val(batchParamDefaultValue[i]);
		}
	}	
}
var batchData = "";
var selRowIndex = [];
var batchParamId = ["batchBackupMode", "batchMbErrorTime", "batchMbRecoverTime","batchBmErrorTime","batchBmRecoverTime", "batchMainMinRate", "batchMainMaxRate", "batchBackupMinRate", "batchBackupMaxRate", "batchSyncError", "batchPidError", "batchScrambleError", "batchCcError", "batchCcErrorMax", "batchCcErrorTime", "batchCcRevertTime"];
var batchParamDefaultValue = [3, 1, 1, 1, 1, 1, 8000, 1, 8000, 0, 0, 0, 0, 2, 1, 1];
function getBatchData()
{
	batchData = "";
	selRowIndex = [];
	var paramData = "";
	//获取当前选中的行号
	$(".row_check").each(function(rowIndex)
	{
		if($(this).prop("checked") == true)
		{
			selRowIndex.push(rowIndex);
		}
	});
	batchData = selRowIndex.join("<*2*>");
	for(var i = 0, len = batchParamId.length; i < len; i++)
	{
		if(i == 0)
		{
			batchData += FIRST_DELIMITER + $("#" + batchParamId[i]).val();
		}
		else if((i > 8) && (i < 13))
		{
			if($("#" + batchParamId[i]).prop("checked") == true)
			{
				batchData += SECOND_DELIMITER + ON;
			}
			else
			{
				batchData += SECOND_DELIMITER + OFF;
			}
		}
		else
		{
			batchData += SECOND_DELIMITER + $("#" + batchParamId[i]).val();
		}
		if($("#" + batchParamId[i] + "Check").prop("checked") == true)
		{
			batchData += THIRD_DELIMITER + ON;
		}
		else
		{
			batchData += THIRD_DELIMITER + OFF;
		}
	}
	return batchData;
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#batchMbErrorTime"), "INT_DEC", 0, 255, "<Main Error Delay(s)>", "<主路错误延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#batchMbRecoverTime"), "INT_DEC", 0, 255, "<Main Revert Delay(s)>", "<主路恢复延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#batchBmErrorTime"), "INT_DEC", 0, 255, "<Backup Error Delay(s)>", "<备路错误延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#batchBmRecoverTime"), "INT_DEC", 0, 255, "<Backup Revert Delay(s)>", "<备路恢复延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#batchCcErrorMax"), "INT_DEC", 0, 1000, "<CC Error Count>", "<CC错误计数>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#batchCcErrorTime"), "INT_DEC", 0, 1000, "<CC Error Delay(s)>", "<CC错误延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#batchCcRevertTime"), "INT_DEC", 0, 1000, "<CC Revert Delay(s)>", "<CC恢复延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#batchMainMinRate"), "INT_DEC", 0, 65535, "<Main Bitrate Lower Limit(Kbps)>", "<主路码率下限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#batchMainMaxRate"), "INT_DEC", 0, 65535, "<Main Bitrate Upper Limit(Kbps)>", "<主路码率上限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#batchBackupMinRate"), "INT_DEC", 0, 65535, "<Backup Bitrate Lower Limit(Kbps)>", "<备路码率下限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#batchBackupMaxRate"), "INT_DEC", 0, 65535, "<Backup Bitrate Upper Limit(Kbps)>", "<备路码率上限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if(parseInt($("#batchMainMinRate").val(), 10) >= parseInt($("#batchMainMaxRate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The main bitrate lower limit should be smaller than the main bitrate upper limit!");
		}
		else
		{
			alert("主路码率下限必须小于主路码率上限！");
		}
		return false
	}
	if(parseInt($("#batchBackupMinRate").val(), 10) >= parseInt($("#batchBackupMaxRate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The backup bitrate lower limit should be smaller than the backup bitrate upper limit!");
		}
		else
		{
			alert("备路码率下限必须小于备路码率上限！");
		}
		return false
	}
	
	return true;
}
function batchBackupApply()
{
	actionType = SET;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PID_BACKUP_ALL + "&cmd=" + actionType + "&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&setString=";
	data += getBatchData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					alert("PID backup modify successfully!");
				}
				else if(language == CHINESE)
				{
					alert("PID备份批量修改成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = (rowIndex - curRespRowNum); i < rowIndex; i++)
	{
		index = i + 1;
		rowData = data[i - (rowIndex - curRespRowNum)].split(SECOND_DELIMITER);
		outSlotNoArray[index] = rowData[objIdArray.length]; //已经不存在的输出卡 的备份删除的时候用到
		for(var j = 0; j < objIdArray.length; j++)
		{
			if(( j == MAIN_DESC_TYPE) || (j == BACKUP_DESC_TYPE))
			{				
				continue;
			}
			else if(j == OUT_PORT)
			{
				$("#" + objIdArray[j] + index).html(getPortDisplayStr(outSlotNo, parseInt(rowData[j], 10), language));
				portDataArray[index] = rowData[j];
			}
			else if((j == MAIN_DESC) || (j == BACKUP_DESC))
			{
				if(parseInt(rowData[j - 1], 10) == SUPPORT_PORT_DESC)
				{
					$("#" + objIdArray[j] + index).html(rowData[j]);
				}
				else
				{
					$("#" + objIdArray[j] + index).html($("#" + objIdArray[j - 2] + index).html());
				}
			}
			else if((j == MAIN_PORT)||(j == BACKUP_PORT))
			{
				$("#" + objIdArray[j] + index).html(getPortDisplayStr((parseInt(rowData[j - 1], 10) - 1), parseInt(rowData[j], 10), language));
			}
			else if(j == BACKUP_MODE)
			{
				$("#" + objIdArray[j] + index).html(backupMode[language][parseInt(rowData[j], 10)]);
			}
			else if(j == WORK_STATE)
			{
				if(parseInt(rowData[j], 10) == INVALID)
				{
					$("#modify" + index).css("display", "none");
					$("#mainDataRow" + index + " td").css("color", "#777e88");
					$("#backupDataRow" + index + " td").css("color", "#777e88");
				}
				else
				{
					$("#modify" + index).css("display", "");
					$("#mainDataRow" + index + " td").css("color", "#000");
					$("#backupDataRow" + index + " td").css("color", "#000");
				}
				$("#" + objIdArray[j] + index).html(workState[language][parseInt(rowData[j], 10)]);
			}
			else
			{
				$("#" + objIdArray[j] + index).html(rowData[j]);
			}			
		}
	}
}

/*************************************************
Function: 		deleteBackup
Description: 	用于删除备份
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function deleteBackup()
{
	var data;
	var rowData;
	var index;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deleteBackup = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the checked backup?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中的备份吗?";
	}
	if(window.confirm(confirmPrompt))
	{
	
		data = "type=" + PID_BACKUP_ALL + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&setString=";	

		for(var i = 0; i < rowNum; i++)
		{
			index = i + 1;
			if($("#check" + index).prop("checked") == true)
			{
				rowData = outSlotNoArray[index] + SECOND_DELIMITER + portDataArray[index] + SECOND_DELIMITER + $("#outPid" + index).html();
				if(deleteNum == 0)
				{
					deleteBackup = rowData;
				}
				else
				{
					deleteBackup += FIRST_DELIMITER + rowData;
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one backup at least!");
			}
			else
			{
				alert("请至少选中一个备份！");
			}
			return;
		}
		data += deleteBackup;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText));
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("Service backup delete successfully!");
					}
					else if(language == CHINESE)
					{
						alert("备份删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function modifyBackup(obj)
{
	var curGbeNo;
	var curPortNo;
	var detailString;
	var index = GetIndexFromId(obj, 11);
	var outProgIdArray = [];
	outProgIdArray.push("O", outSlotNo + 1, portDataArray[index], $("#outPid" + index).html());
	outProgId = outProgIdArray.join("_");
	if(parseInt(outSlotNo, 10) == MAIN_GBE_CARD)
	{
		if(parseInt(outProgIdArray[2], 10) > ONE_GBE_PORT_NUM)
		{
			curGbeNo = GBE_TWO;
			curPortNo = parseInt(outProgIdArray[2], 10) - ONE_GBE_PORT_NUM;
		}
		else
		{
			curGbeNo = GBE_ONE;
			curPortNo = outProgIdArray[2];
		}
		detailString = " > " + mainMenu[language] + " > " + treeMenu[language] + " > " + detailMenu[language] + " (" + cardArray[language] + outProgIdArray[1] + "-" + gbeArray[language] + curGbeNo + portArray[language] + curPortNo + progArray[language] + outProgIdArray[3] + ")";
	}
	else
	{
		detailString = " > " + mainMenu[language] + " > " + treeMenu[language] + " > " + detailMenu[language] + " (" + cardArray[language] + outProgIdArray[1] + "-" + portArray[language] + outProgIdArray[2] + progArray[language] + outProgIdArray[3] + ")";
	}
	if(language == ENGLISH)
	{
		self.location.replace("../mux/pid_backup_en.asp?ID=" + outProgId);		
	}
	else
	{
		self.location.replace("../mux/pid_backup_cn.asp?ID=" + outProgId);
	}
	parent.document.getElementById( "menuBar").innerHTML = detailString;
}
