var zTree;
var inputArray;
var outputArray;
var inCardNum;
var outCardNum;
var OPER_MUX_APPLY = 1;
//设置配置参数 和 方法
var setting = {
	editable: false,//参数设置为true便可使用拖拽功能
	edit_renameBtn: false,
	edit_removeBtn: false,
	dragCopy: true,//拖拽功能为复制然后在目的菜单添加
	dragMove: false,//拖拽功能为先删除然后在目的菜单添加
	data: {
		key: {
			children: "nodes"
		},
	},
	check: {
		enable: true,
		chkStyle: "checkbox"
	},
	view: {
		showLine: false,
		showTitle: false,
		showIcon: false
	},
	callback: {}
};

var TREE_BLANK_HEIGHT = 38;
var IFRAME_BLANK_HEIGHT = 17;
var rightIframeHeight;
var id;
var muxServiceId;
var serviceIdChange = false;

function treeOnClick(event, treeId, treeNode) {
	self.frames[0].location.replace(treeNode.href);
}
function generateOption()
{
	var data;
	var response;
	var cardArray;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + MUX_CONFIG + "&cmd=" + GET +
		"&language=" + language + "&slotNo=" + slotNo + "&funType=" + OPER_MUX_APPLY + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			cardArray = response.split(FIRST_DELIMITER);
			if(cardArray[0] == "")
			{
				inCardNum = 0;
			}
			else
			{
				inputArray = cardArray[0].split(SECOND_DELIMITER);
				inCardNum = inputArray.length;
			}
			if(cardArray[1] == "")
			{
				outCardNum = 0;
			}
			else
			{
				outputArray = cardArray[1].split(SECOND_DELIMITER);
				outCardNum = outputArray.length;
			}
			updateOutput();
		}
	}
	xmlHttp.send(null);
}

function generateInTsOption()
{
	var data;
	var response;
	var cardArray;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PID_MAP_LIST + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			cardArray = response.split(FIRST_DELIMITER);
			inputArray = cardArray[0].split(SECOND_DELIMITER);
			outputArray = cardArray[1].split(SECOND_DELIMITER);
			populateCard();
			refreshFlag = true;
		}
	}
	xmlHttp.send(null);
}

function populateCard()
{
	var editInCard;
	var inCardInfo;
	var option;

	editInCard = $("#editInCard");
	editInCard.empty();
	if(inputArray[0] == "")
	{
		option = $("<option>").text(noCardList[language]).val(NO_CARD);
		editInCard.append(option);
	}
	else
	{
		for(var i = 0; i < inputArray.length; i++)
		{
			inCardInfo = inputArray[i].split(THIRD_DELIMITER);
			if(inCardInfo.length == 2) // 卡存在但没有端口的情况
			{
				continue;
			}
			option = $("<option>").text(inCardInfo[0]).val(inCardInfo[1]);
			editInCard.append(option);	
		}
		if($("option", editInCard).length == 0)
		{
			option = $("<option>").text(noCardList[language]).val(NO_CARD);
			editInCard.append(option);
		}
	}
	populateInputPort($("#editInCard"));
}

/*************************************************
 Function:        updateOutput
 Description:    输出卡的初始化
 Input:            无
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function updateOutput() {
	var outputCard;
	var outCardInfo;
	var outCardValue;
	var option;

	outputCard = $("#outputCard");
	outputCard.empty();

	if (outCardNum == 0) {
		option = $("<option>").text(noCardList[language]).val(NO_CARD);
		outputCard.append(option);
	}
	else {
		for (var i = 0; i < outCardNum; i++) {
			outCardInfo = outputArray[i].split(THIRD_DELIMITER);
			option = $("<option>").text(outCardInfo[0]).val(outCardInfo[1]);
			outputCard.append(option);
		}
		if (parent.outSlotNo == -1) {
			outCardValue = outputCard.get(0).options[0].value;
		}
		else {
			outCardValue = parent.outSlotNo;
		}
		outputCard.val(outCardValue);
		changeOutput();
	}
}
/*************************************************
 Function:        changeOutput
 Description:    输出卡切换
 Input:            无
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function changeOutput() {
	var outCardValue = parseInt($("#outputCard").val(), 10);
	zTree2 = $.fn.zTree.init($("#outputTree"), setting, eval("zOutNode" + (outCardValue + 1))[0].nodes);
}
function resizeHeight() {
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	$(".mux_tree_content").css("height", function (index, value) {
		return ((parent.iframeHeight - TREE_BLANK_HEIGHT - 31) + "px");
	});
	rightIframeHeight = parent.iframeHeight - IFRAME_BLANK_HEIGHT;
	$(".div_content").css("height", function (index, value) {
		return (rightIframeHeight + "px");
	});
}

window.onresize = function () {
	resizeHeight();
}

$(document).ready(function () {
	var args = GetArgs();
	id = args["ID"];

	resizeHeight();
	funcUpdateDisplay();
});
function pageRefresh()
{
	PageRefresh(TOP);
}
function funcUpdateDisplay() {
	PageLoadStatus(true);

	generateOption();
	generateInTsOption();
	resetDefault();

	ResetColor();
	PageLoadStatus(false);
}

function resetDefault(){
	$("#editInPid").val("");
	$("#editInPidStep").val("");
	$("#editOutPid").val("");
	$("#lowerPriority").prop("checked",false);
}

function populateInputPort(obj)
{
	var editInPort = $("#editInPort");
	var option;
	var cardNo = parseInt(obj.val(), 10);

	editInPort.empty();
	if(cardNo == NO_CARD)
	{
		option = $("<option>").text(noPortList[language]).val(NO_PORT);
		editInPort.append(option);
	}
	else
	{
		for(var i = 0, len = inputArray.length; i < len; i++)
		{
			var inCardInfo = inputArray[i].split(THIRD_DELIMITER);
			if(inCardInfo[1] ==  cardNo)
			{
				var portNum = inCardInfo.length - 2;
				break;
			}
		}
		var displayStr;
		for(var i = 0; i < portNum; i++)
		{
			displayStr = getPortDisplayStr(cardNo, parseInt(inCardInfo[2 + i]), language);
			option = $("<option>").text(displayStr).val(parseInt(inCardInfo[2 + i]) - 1);
			editInPort.append(option);
		}
	}
}
/*-------------------------------------------------
 根据勾选的输出端口和配置的参数，组织pidmap的数据
 --------------------------------------------------*/
function generatePidMap(){
	var mainTree = $.fn.zTree.getZTreeObj("outputTree");
	var _nodes = mainTree.getCheckedNodes(true);
	if(_nodes.length == 0){
		if(language == ENGLISH)
		{
			alert("Please select one port at least!");
		}
		else if(language == CHINESE)
		{
			alert("请选择输出端口！");
		}
		return;
	}
	var outputList = [];
	for(var  i = 0; i < _nodes.length; i++){
		outputList.push(_nodes[i].ID);
	}
	var data;
	var xmlHttp = GetHTTPObject();
	var response;

	if(paramCheck() == false)
	{
		return;
	}

	data = "type=35&cmd=" + ADD + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += outputList.join(SECOND_DELIMITER) + FIRST_DELIMITER + $("#editInCard").val() + FIRST_DELIMITER + $("#editInPort").val() + FIRST_DELIMITER + $("#editInPid").val() + FIRST_DELIMITER + $("#editInPidStep").val() + FIRST_DELIMITER + $("#editOutPid").val();
	if($("#lowerPriority").prop("checked") == true)
	{
		data += FIRST_DELIMITER + 1;
	}
	else
	{
		data += FIRST_DELIMITER + 0;
	}

	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					alert("PID Map add successfully!");
				}
				else if(language == CHINESE)
				{
					alert("PID映射添加成功！");
				}
				if(language == ENGLISH)
				{
					self.location.replace("pid_map_en.asp");
				}
				else
				{
					self.location.replace("pid_map_cn.asp");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			/*funcUpdateDisplay();*/
		}
	}
	xmlHttp.send(data);
}
function paramCheck()
{
	if((parseInt($("#editInCard").val(), 10) == NO_CARD))
	{
		$.modal.close();
		if(language == ENGLISH)
		{
			alert("Card List is empty, so can't add PID map!");
		}
		else
		{
			alert("卡列表为空，不能添加PID映射！");
		}
		return false;
	}
	if(ValidateParam($("#editInPid"), "INT_DEC_HEX", 0, 8191, "<Input PID>", "<输入PID>", language) == false)
	{
		return false;
	}
	if(ValidateParam($("#editInPidStep"), "INT_DEC_HEX", 0, 8191, "<PID Step>", "<PID步进值>", language) == false)
	{
		return false;
	}
	if(ValidateParam($("#editOutPid"), "INT_DEC_HEX", 0, 8191, "<Output PID>", "<输出PID>", language) == false)
	{
		return false;
	}
	return true;
}