﻿var localTimeIdArray = ["localOffsetHour", "localOffsetMin"];
var timeChangeIdArray = ["year", "month", "day", "hour", "min", "sec"];
var nextTimeIdArray = ["nextOffsetHour", "nextOffsetMin"];
var objIdArray = ["tdtSwitch", "tdtIntetval", "totSwitch", "totIntetval", "countryCode", "countryRegionId", "offsetPolarity", localTimeIdArray, timeChangeIdArray, nextTimeIdArray];
var ROW_NUM = 10;
var LOCAL_TIME = 7;

var TDT_NOTE = 0;
var TOT_NOTE = 2;
var POLARITY_NOTE = 6;

var TDT = 0;
var TOT = 1;
var POLARITY = 2;
var NOTE_NUM = 3;

window.onresize = function()
{
  GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();	
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var rowData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + TABLE_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < LOCAL_TIME; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				
				for(var i = LOCAL_TIME; i < ROW_NUM; i++)
				{
					rowData = data[i].split(SECOND_DELIMITER);
					length = rowData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(rowData[j]);
					}	
				}
	
				for(var i = 0; i < NOTE_NUM; i++)
				{
					changeDisplay(i);
				}
				
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + TABLE_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	var length;
	var rowData;
	
	for(var i = 0; i < LOCAL_TIME; i++)
	{
		rowData =  $("#" + objIdArray[i]).val();
		if(i == 0)
		{
			data = rowData;
		}
		else
		{
			data += FIRST_DELIMITER + rowData;
		}
	}
	for(var i = LOCAL_TIME; i < ROW_NUM; i++)
	{
		length = objIdArray[i].length;		
		for(var j = 0; j < length; j++)
		{
			if(j == 0)
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
		}
	}
	
	return data;
}

function paramCheck()
{
 	var returnFlag;
				
	returnFlag = ValidateParam($("#tdtIntetval"), "INT_DEC", 0, 30, "<TDT Interval(s)>", "<TDT发表间隔(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
			
	returnFlag = ValidateParam($("#totIntetval"), "INT_DEC", 0, 30, "<TOT Interval(s)>", "<TOT发表间隔(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#countryCode"), "LENGTH", 3, 3, "<Country Code>", "<国家代码>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = validateCountryCode($("#countryCode"), "<Country Code>", "<国家代码>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#year"), "INT_DEC", 1900, 2100, "<Time of Change Year>", "<时间变化 年>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#month"), "INT_DEC", 1, 12, "<Time of Change Month>", "<时间变化 月>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	var tempMonth = parseInt($("#month").val(), 10);
	var tempYear = parseInt($("#year").val(), 10);	
	if((tempYear == 1900) && (tempMonth < 3))
	{
		if(language == ENGLISH)
		{
			alert("Please input valid date!");
		}
		else
		{
			alert("请输入合法的日期!");
		}		
		return false;
	}
	if((tempYear == 2100) && (tempMonth > 2))
	{
		if(language == ENGLISH)
		{
			alert("Please input valid date!");
		}
		else
		{
			alert("请输入合法的日期!");
		}
		return false;
	}
	if(tempMonth == 2)
	{
		if((tempYear % 4) == 0)
		{			
			if(((tempYear % 100) != 0)||((tempYear % 400) == 0))
			{
				returnFlag = ValidateParam($("#day"), "INT_DEC", 1, 29, "<Time of Change Day>", "<时间变化 日>", language);
				if(returnFlag == false)
				{
					return false;
				}
			}
		}
		else
		{
			returnFlag = ValidateParam($("#day"), "INT_DEC", 1, 28, "<Time of Change Day>", "<时间变化 日>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	else if((tempMonth == 4)&&(tempMonth == 6)&&(tempMonth == 9)&&(tempMonth == 11))
	{
		returnFlag = ValidateParam($("#day"), "INT_DEC", 1, 30, "<Time of Change Day>", "<时间变化 日>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else
	{
		returnFlag = ValidateParam($("#day"), "INT_DEC", 1, 31, "<Time of Change Day>", "<时间变化 日>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	returnFlag = ValidateParam($("#hour"), "INT_DEC", 0, 23, "<Time of Change Hour>", "<时间变化 时>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#min"), "INT_DEC", 0, 59, "<Time of Change Minute>", "<时间变化 分>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#sec"), "INT_DEC", 0, 59, "<Time of Change Second>", "<时间变化 秒>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#localOffsetHour"), "INT_DEC", 0, 13, "<Local Time Offset Hour>", "<本地时间偏移 时>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#localOffsetMin"), "INT_DEC", 0, 59, "<Local Time Offset Minute>", "<本地时间偏移 分>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#nextOffsetHour"), "INT_DEC", 0, 13, "<Next Time Offset Hour>", "<下一时间偏移 时>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#nextOffsetMin"), "INT_DEC", 0, 59, "<Next Time Offset Minute>", "<下一时间偏移 分>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	
	return true;
}

function validateCountryCode(obj, str1, str2, language)
{
	var strVal = obj.val();
	for ( i = 0 ; i < strVal.length ; i++ )
	{      
		ch = strVal.charAt(i);
		if( ch < "A" || ch > "Z")
		{
			if(language == ENGLISH)
			{
				alert(str1 + "Please input valid code!");
			}
			else
			{
				alert(str2 + "请输入合法的代码!");
			}				
			setTimeout(function () {obj.focus()}, 0);
			setTimeout(function () {obj.select()}, 0);
			return false;
		}
	}				
}

function changeDisplay(type)
{
	switch(type)
	{
		case TDT:	
			if(parseInt($("#" + objIdArray[TDT_NOTE]).val(), 10) == ON)
			{
				if(language == ENGLISH)
				{
					$("#tdtNote").html("Allow to send TDT table");
				}
				else
				{
					$("#tdtNote").html("允许发送TDT表");
				}
			}
			else
			{
				if(language == ENGLISH)
				{
					$("#tdtNote").html("Don't allow to send TDT table");
				}
				else
				{
					$("#tdtNote").html("不允许发送TDT表");
				}
			}	
			break;
		case TOT:	
			if(parseInt($("#" + objIdArray[TOT_NOTE]).val(), 10) == ON)
			{
				if(language == ENGLISH)
				{
					$("#totNote").html("Allow to send TOT table");
				}
				else
				{
					$("#totNote").html("允许发送TOT表");
				}
			}
			else
			{
				if(language == ENGLISH)
				{
					$("#totNote").html("Don't allow to send TOT table");
				}
				else
				{
					$("#totNote").html("不允许发送TOT表");
				}
			}
			break;
		case POLARITY:	
			if(parseInt($("#" + objIdArray[POLARITY_NOTE]).val(), 10) == ON)
			{
				if(language == ENGLISH)
				{
					$("#offsetPolarityNote").html("Negative polarity, local time behind to UTC");
				}
				else
				{
					$("#offsetPolarityNote").html("极性是负的，本地时间落后于UTC");
				}
			}
			else
			{
				if(language == ENGLISH)
				{
					$("#offsetPolarityNote").html("Positive polarity, local time advanced to UTC");
				}
				else
				{
					$("#offsetPolarityNote").html("极性是正的，本地时间超前于UTC");
				}
			}
			break;
		default:
			break;
	}	
}