﻿var sampleRateIdArray = ["sampleRate"];
var audioEncode1IdArray = ["workMode1", "encodingType1", "lrSel1", "clfeSel1", "lsrsSel1", "bitrate1", "volume1", "mode1", "delay1", "pesAlign1"];
var audioEncode2IdArray = ["workMode2", "encodingType2", "lrSel2", "clfeSel2", "lsrsSel2", "bitrate2", "volume2", "mode2", "delay2", "pesAlign2"];
var objIdArray = [sampleRateIdArray, audioEncode1IdArray, audioEncode2IdArray];
var SEC_NUM = 3;
var identifyData;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_AUDIO + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				identifyData = data[SEC_NUM];
				for(var i = 0; i < SEC_NUM; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					length = sectionData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(sectionData[j]);
					}
				}
				if(identifyData == 0)
				{
					$("#lrSel1").attr("disabled", true);
					$("#lrSel2").attr("disabled", true);
					$("#volume1").attr("disabled", false);
					$("#volume2").attr("disabled", false);
					$("#pesAlign1").attr("disabled", false);
					$("#pesAlign2").attr("disabled", false);
				}
				else
				{
					$("#lrSel1").attr("disabled", false);
					$("#lrSel2").attr("disabled", false);
					$("#volume1").attr("disabled", true);
					$("#volume2").attr("disabled", true);
					$("#pesAlign1").attr("disabled", true);
					$("#pesAlign2").attr("disabled", true);
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_AUDIO + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#delay1"), "INT_DEC", -50, 300, "<Audio 1 Delay(ms)>", "<音频1延时(ms)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#delay2"), "INT_DEC", -50, 300, "<Audio 2 Delay(ms)>", "<音频2延时(ms)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < SEC_NUM; i++)
	{
		length = objIdArray[i].length;
		for(var j = 0; j < length; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[i][j]).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
		}
	}
	
	return data;
}