var readObj = ["logoInfo"];
var editObj = ["logoClear", "switch", "destinationX", "destinationY", "logoType", "opacity"];
var READ_COL_NUM = 1;
var EDIT_COL_NUM = 6;
var ROW_NUM = 6;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var rowData;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_LOGO + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					rowData = data[i].split(SECOND_DELIMITER);
					for(var j = 0; j < READ_COL_NUM; j++)
					{
						$("#" + readObj[j] + (i + 1)).html(rowData[j]);
					}
					for(var j = 0; j < EDIT_COL_NUM; j++)
					{
						$("#" + editObj[j] + (i + 1)).val(rowData[j + READ_COL_NUM]);
					}
				}
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	if(paramCheck() == false)
	{
		return;
	}
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	data = "type=" + PORT_LOGO + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	
	for(var i = 0;  i < ROW_NUM; i++)
	{
		for(var j = 0; j < EDIT_COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + editObj[j] + (i + 1)).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + editObj[j] + (i + 1)).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + editObj[j] + (i + 1)).val();
			}
		}
	}
	
	return data;
}

function paramCheck()
{
 	var returnFlag;
	for(var i = 0; i < ROW_NUM; i++)
	{
		returnFlag = ValidateParam($("#destinationX" + (i + 1)), "INT_DEC", 0, 1919, "<Destination X>", "<横坐标>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#destinationY" + (i + 1)), "INT_DEC", 0, 1079, "<Destination Y>", "<纵坐标>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#opacity" + (i + 1)), "INT_DEC", 0, 100, "<Opacity(%)>", "<透明度(%)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}