/*************************************************
Copyright (C), 2000-2010, Sumavision Tech. Co., Ltd.
File name: 		card_common.js  
Author:			zhaoliying
Version:		v1.0
Date: 			2013/07/10
Description:  	C302SI卡页面公用js代码模块
*************************************************/
//type value
var CARD_SYSTEM = 1;
var CARD_PROGRAM = 2;
var FILE_LIST = 3;
var CARD_STATUS = 4;
var CARD_DATA = 5;
var CARD_OTHER = 8;

var PID_MAP_LIST = 201;

var NO_CARD = 7;
var NO_PORT = 7;
var noCardList = ["None", "无卡"];
var noPortList = ["None", "无端口"];

var gbeStrArray = ["GbE", "网口"];
var portStrArray = ["Port", "端口"];

var errorEn = ["",
			   "The parameter value is illegal!"];

var errorCn = ["",
			   "非法参数值！"];
			   
var returnError = [errorEn, errorCn];
/*************************************************
Function: 		getPortDisplayStr
Description: 	用于生成显示端口号的文字描述
Input: 			slotNo: 卡号，从0开始;
				portNo: 端口号，从1开始
				language: 1-English; 2-Chinese
Output: 		无
Return: 		显示的字符串
Others: 		无
*************************************************/
function getPortDisplayStr(slotNo, portNo, language)
{
	var displayStr;
	
	if(slotNo == MAIN_GBE_CARD)
	{
		if(portNo <= 256)
		{
			displayStr = gbeStrArray[language] + "1" + portStrArray[language] + portNo;
		}
		else
		{
			displayStr = gbeStrArray[language] + "2" + portStrArray[language] + (portNo - 256);
		}
	}
	else
	{
		displayStr = portStrArray[language] + portNo;
	}
	
	return displayStr;
}

/*************************************************
Function: 		pageJump
Description: 	用于页面横向跳转的函数
Input: 			index: 1-CARD_SYSTEM; 2-CARD_PROGRAM
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function pageJump(index)
{
	if(index == CARD_SYSTEM)
	{
		window.location.href = "card" + pageLanguage[language] + "?slotNo=" + slotNo;
 	}
 	else if(index == CARD_PROGRAM)
 	{
		window.location.href = "card_program" + pageLanguage[language] + "?slotNo=" + slotNo;
	}
	else if(index == CARD_DATA)
 	{
		window.location.href = "card_data" + pageLanguage[language] + "?slotNo=" + slotNo;
	}
	/*else if(index == CARD_DELAY)
 	{
		window.location.href = "card_delay" + pageLanguage[language] + "?slotNo=" + slotNo;
	}*/
	else if(index == CARD_OTHER)
 	{
		window.location.href = "card_other" + pageLanguage[language] + "?slotNo=" + slotNo;
	}
}