﻿var generalIdArray = ["alarmSwitch"];
var videoIdArray = ["videoSwitch", "videoFormat", "bitrateMode", "videoBitrate", "vbr", "gopStructure", "gopSize", "videoLevel", "chromaPhase", "blackLevel", "chromaGain",  "aspectRatio", "resolution", "videoNoSource"];
var audioIdArray = ["mp2Coding", "mp2Mode", "mp2Volume", "mp2Bitrate", "mp2SampleRate", 
					"ac3Coding", "ac3Mode", "ac3Volume", "ac3Bitrate", "ac3SampleRate", "ac3CodingDelay",
					 "draCoding" ,"draMode", "draBitrate", "draSampleRate", "draCodingDelay"];
var tsIdArray = ["multiplex", "serviceId", "serviceName", "serviceProvider", "pcrPid", "pmtPid", "videoPid", "mp2Pid", "ac3Pid", "draPid"];
var vbiIdArray = ["ccSwitch", "evenFieldSwitch", "evenFieldLine", "oddFieldSwitch", "oddFieldLine", "ttSwitch", "ttPid"];
var objIdArray = [generalIdArray, videoIdArray, audioIdArray, tsIdArray, vbiIdArray];
var SEC_NUM = 5;
var identifyData;
var AC3 = 0;
var DRA = 1;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				identifyData = data[SEC_NUM];
				changeAudioMode();
				for(var i = 0; i < SEC_NUM; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					length = sectionData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(sectionData[j]);
					}
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function changeAudioMode()
{	
	if(identifyData == AC3)
	{
		$("#ac3Parameter").css("display", "");
		$("#ac3DisplayPid").css("display", "");
		$("#draParameter").css("display", "none");
		$("#draDisplayPid").css("display", "none");
	} 
	else if(identifyData == DRA)
	{
		$("#ac3Parameter").css("display", "none");
		$("#ac3DisplayPid").css("display", "none");
		$("#draParameter").css("display", "");
		$("#draDisplayPid").css("display", "");
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	var bitrateDiffer;
	
	returnFlag = ValidateParam($("#videoBitrate"), "INT_DEC", 1500000, 15000000, "<Bitrate(bps)>", "<码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#vbr"), "INT_DEC", 1300000, 14800000, "<VBR(bps)>", "<VBR(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	bitrateDiffer = parseInt($("#videoBitrate").val(), 10) - parseInt($("#vbr").val(), 10);
   	if(bitrateDiffer < 200000)
    {
		if(language == ENGLISH)
		{
			alert("VBR must be lower than video bitrate at least 200000bps!");
		}
		else
		{
			alert("VBR视频平均码率应低于视频码率至少200000bps！");
		}		
		return false;
    }
	returnFlag = ValidateParam($("#gopSize"), "INT_DEC", 4, 30, "<Gop Size>", "<Gop长度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#videoLevel"), "INT_DEC", 0, 255, "<Video Level>", "<亮度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#chromaPhase"), "INT_DEC", 0, 255, "<Chroma Phase>", "<色度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#blackLevel"), "INT_DEC", 0, 255, "<Black Level>", "<对比度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#chromaGain"), "INT_DEC", 0, 255, "<Chroma Gain>", "<饱和度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(identifyData == AC3)
	{
		returnFlag = ValidateParam($("#ac3CodingDelay"), "INT_DEC", -500, 500, "<AC3 Coding Delay(ms)>", "<AC3编码延时(ms)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(identifyData == DRA)
	{
		returnFlag = ValidateParam($("#draCodingDelay"), "INT_DEC", -500, 500, "<DRA Coding Delay(ms)>", "<DRA编码延时(ms)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	
	returnFlag = ValidateParam($("#serviceId"), "INT_DEC_HEX", 0, 65535, "<Service ID>", "<节目号>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#serviceName"), "LENGTH", 0, 15, "<Service Name>", "<节目名称>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#serviceName"), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#serviceProvider"), "LENGTH", 0, 15, "<Service Provider>", "<节目提供商>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#serviceProvider"), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#pcrPid"), "INT_DEC_HEX", 32, 8190, "<PCR PID>", "<PCR PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#pmtPid"), "INT_DEC_HEX", 32, 8190, "<PMT PID>", "<PMT PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#videoPid"), "INT_DEC_HEX", 32, 8190, "<Video PID>", "<视频PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#mp2Pid"), "INT_DEC_HEX", 32, 8190, "<MP2 PID>", "<MP2 PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(identifyData == AC3)
	{
		returnFlag = ValidateParam($("#ac3Pid"), "INT_DEC_HEX", 32, 8190, "<AC3 PID>", "<AC3 PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(identifyData == DRA)
	{
		returnFlag = ValidateParam($("#draPid"), "INT_DEC_HEX", 32, 8190, "<DRA PID>", "<DRA PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}	
	returnFlag = ValidateParam($("#ttPid"), "INT_DEC_HEX", 32, 8190, "<TT PID>", "<TT PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < SEC_NUM; i++)
	{
		length = objIdArray[i].length;
		for(var j = 0; j < length; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[i][j]).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
		}
	}	
	return data;
}