/*************************************************
Copyright (C), 2000-2010, Sumavision Tech. Co., Ltd.
File name: 		card_common.js  
Author:			wangyuqi
Version:		v1.0
Date: 			2013/06/05
Description:  	C404R兆卡页面公用js代码模块
History: 
1. Date: Author: Modification:
2. ...
*************************************************/
//type value
var CARD_GENERAL = 1;
var PLP_REPLACE = 2;
var PSI_REPLACE = 3;
var PORT_IN_MONITOR = 4;
var PORT_OUT_MONITOR = 5;
var PORT_IN_CONFIG = 6;
var PORT_OUT_CONFIG = 7;
var PORT_IN_PSI = 8;


var errorEn = ["",
			   "The parameter value is illegal!",
			   "The main PLP has already been replaced!",
			   "You can not set the input mode as This Card when port has been set to pass-through!",
			   "The maximal number of replaced PLP list is 16!"];

var errorCn = ["",
			   "非法参数值！",
			   "主路PLP已被替换！",
			   "端口有透传时不能设置为本卡输入！",
			   "最多支持16对替换！"];
			   
var returnError = [errorEn, errorCn];

/*************************************************
Function: 		pageJump
Description: 	横向菜单的切换
Input: 			type: page type
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function pageJump(type)
{	
	switch(type)
	{
		case CARD_GENERAL:
			window.location.href = "card" + pageLanguage[language] + "?slotNo=" + slotNo;			
			break;
		case PLP_REPLACE:
			window.location.href = "plp_replace" + pageLanguage[language] + "?slotNo=" + slotNo;		
			break;
		case PSI_REPLACE:
			window.location.href = "psi_replace" + pageLanguage[language] + "?slotNo=" + slotNo;		
			break;
		case PORT_IN_MONITOR:
			window.location.href = "port_in" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;			
			break;
		case PORT_OUT_MONITOR:
			window.location.href = "port_out" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;			
			break;
		case PORT_IN_PSI:
			window.location.href = "port_in_psi" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;			
			break;
		case PORT_IN_CONFIG:
			window.location.href = "port_in_config" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;		
			break;
		case PORT_OUT_CONFIG:
			window.location.href = "port_out_config" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;	
			break;
		default:
			break;
	}
}

