﻿var rowNum;

var objIdArray = ["index", "mainId", "backupId"];
var COL_NUM = 3;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	
	$("input[type=checkbox]").live("click", function()
	{
		EnableButton("deleteBtn");
	});
	AddTabMouseAction("psi");
});

function funcUpdateDisplay() 
{		
	DisableButton("addBtn");
	DisableButton("deleteBtn");
	DisableButton("deleteAllBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("addBtn");
	EnableButton("deleteAllBtn");
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PLP_REPLACE + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response == "")
			{
				rowNum = 0;
			}
			else
			{
				data = response.split(FIRST_DELIMITER);
				rowNum = data.length;
			}
			DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
			if(rowNum != 0)
			{
				updateTableData(data);
			}
			refreshFlag = true;
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			$("#" + objIdArray[j] + index).html(rowData[j]);
		}
	}
}

function checkAll()
{
	for(var i = 0; i < rowNum; i++)
	{
		$("#check" + (i + 1)).prop("checked", $("#checkAll").prop("checked"));
	}
	
}

function addPlp()
{
	$("#editMainId").val("");
	$("#editBackupId").val("");
	$("#editPlp").modal();
}

function editPlpApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
 	var returnFlag;
	
	returnFlag = ValidateParam($("#editMainId"), "INT_DEC", 0, 255, "<Port 1 PLP ID(Main)>", "<端口1 PLP ID(主路)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#editBackupId"), "INT_DEC", 0, 255, "<Port 2 PLP ID(Backup)>", "<端口2 PLP ID(备路)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	data = "type=" + PLP_REPLACE + "&cmd=" + ADD + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	
	data += $("#editMainId").val() + FIRST_DELIMITER + $("#editBackupId").val();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					alert("PLP is added successfully!");
				}
				else if(language == CHINESE)
				{
					alert("PLP添加成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
	return true;
}

function cancelEdit()
{
	$.modal.close();
}

function deletePlp()
{
	var data;
	var index;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deletePlpIndex = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the selected PLP?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中PLP吗？";
	}
	
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + PLP_REPLACE + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
		
		for(var i = 0; i < rowNum; i++)
		{
			index = i + 1;
			if($("#check" + index).prop("checked") == true)
			{
				if(deleteNum == 0)
				{
					deletePlpIndex = $("#index" + index).html();
				}
				else
				{
					deletePlpIndex += FIRST_DELIMITER + $("#index" + index).html();
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one PLP at least!");
			}
			else
			{
				alert("请至少选中一个PLP！");
			}
			return;
		}
		data += deletePlpIndex;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The checked PLP are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("选中PLP删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function deleteAll()
{
	var confirmPrompt;
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(rowNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("The PLP number is 0!");
		}
		else if(language == CHINESE)
		{
			alert("PLP个数是0！");
		}
		return;
	}
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all the PLP?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除全部PLP吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + PLP_REPLACE + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&setString=0xffff";
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("PLP are all deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("所有PLP删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}