﻿var objIdArray = ["inputMode", "packagePid", "minPid", "maxPid", "alarmSwitch"];
var ROW_NUM = 5;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var response;
	var pidArr;
	var pidNum;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_IN_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				if(data[ROW_NUM] == "")
				{
					pidNum = 0;
				}
				else
				{
					pidArr = data[ROW_NUM].split(SECOND_DELIMITER);
					pidNum = pidArr.length;
				}
				DrawTableRow("dataTable", "dataRow", "CaseRow", pidNum);
				if(pidNum != 0)
				{
					updateTableData(pidArr, pidNum);
				}
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data, rowNum)
{
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		$("#index" + index).html(index);
		$("#pid" + index).html(data[i]);
	}
}

function sendRequest(url)
{
	var tId = parent.curTree.getSelectedNodes()[0].tId;
	var selectNode;
	var xmlHttp = GetHTTPObject();
	xmlHttp.open("GET", url, true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			ExecuteScript(xmlHttp.responseText);
			selectNode = parent.curTree.getNodeByTId(tId);
			parent.curTree.selectNode(parent.curTree.getNodeByTId(tId));
		}
	}
	xmlHttp.send(null);
}

var inputModeFlag = false;
function changeInputMode()
{	
	inputModeFlag = true;
}

function changeTree()
{
	if(inputModeFlag == true)
	{
		sendRequest("../frame" + pageLanguage[language] + "?ran=" + Math.random());
		inputModeFlag = false;
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_IN_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			changeTree();
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;

	returnFlag = ValidateParam($("#packagePid"), "INT_DEC_HEX", 0, 8191, "<PID (Catch T2MI Package)>", "<PID(抓取T2MI包)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#minPid"), "INT_DEC_HEX", 0, 8191, "<Min PID>", "<PID下限>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#maxPid"), "INT_DEC_HEX", 0, 8191, "<Max PID>", "<PID上限>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(unifyDataFormat($("#minPid")) > unifyDataFormat($("#maxPid")))
	{
		if(language == ENGLISH)
		{
			alert("<Min PID> should be smaller than <Max PID>!");
		}
		else
		{
			alert("码率下限要小于码率上限！");
		}
		return false;
	}
	return true;
}


function generateData()
{
	var data;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}