﻿var objIdArray = ["syncStatus", "streamScramble", "totalBitrate", "effectiveBitrate", "rangeBitrate", "guardInterval", "constellation", "pilotPattern", "networkId", "t2SystemId", "t2Version", "freqAmount", "plpAmount"];
var OBJ_NUM = 13;
var freqIdArray = ["freqRowIndex", "freqIndex", "freqValue"];
var FREQ_COL_NUM = 3;
var plpIdArray = ["plpRowIndex", "plpIndex", "plpType", "codeRate", "modulation", "frameInterval", "timeType", "timeInterval", "plpMode", "blockNum"];
var PLP_COL_NUM = 10;
var freqNum;
var plpNum;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	setInterval("displayParam();", 10000);
});

function funcUpdateDisplay() 
{
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var syncStatusEn = ["No Sync", "188 Pkt Sync", "204 Pkt Sync"];
	var syncStatusCn = ["未同步", "188包同步", "204包同步"];
	var syncStatus = [syncStatusEn, syncStatusCn];
	var scrambleStatusEn = ["Descramble", "Scramble"];
	var scrambleStatusCn = ["未加扰", "加扰"];
	var scrambleStatus = [scrambleStatusEn, scrambleStatusCn];
	var reserved = ["Reserved", "保留"];
	var guardInterval = ["1/32", "1/16", "1/8", "1/4", "1/128", "19/128", "19/256"];
	var constellation = ["BPSK", "QPSK", "16-QAM", "64-QAM"];
	
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	var freqArray;
	var plpArray;
	var intData;
	var syncValue;
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_IN_MONITOR + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				syncValue = parseInt(data[0], 10);
				if(syncValue == 0)
				{
					$("#t2Tr").css("display", "none");
				}
				else
				{
					$("#t2Tr").css("display", "");
				}
				for(var i = 0; i < OBJ_NUM; i++)
				{
					intData = parseInt(data[i], 10);
					if(i == 0)
					{
						$("#" + objIdArray[i]).html(syncStatus[language][intData]);
					}
					else if(i == 1)
					{
						$("#" + objIdArray[i]).html(scrambleStatus[language][intData]);
					}
					else if(i == 5)
					{
						if(intData != 7)
						{
							$("#" + objIdArray[i]).html(guardInterval[intData]);
						}
						else
						{
							$("#" + objIdArray[i]).html(reserved[language]);
						}
					}
					else if(i == 6)
					{
						if(intData <= 3)
						{
							$("#" + objIdArray[i]).html(constellation[intData]);
						}
						else
						{
							$("#" + objIdArray[i]).html(reserved[language]);
						}
					}
					else if(i == 7)
					{
						if(intData <= 7)
						{
							$("#" + objIdArray[i]).html("PP" + (intData + 1));
						}
						else
						{
							$("#" + objIdArray[i]).html(reserved[language]);
						}
					}
					else if(i == 10)
					{
						if(intData <= 2)
						{
							$("#" + objIdArray[i]).html("1." + (intData + 1) + ".1");
						}
						else
						{
							$("#" + objIdArray[i]).html(reserved[language]);
						}
					}
					else
					{
						$("#" + objIdArray[i]).html(data[i]);
					}
				}
				if(data[OBJ_NUM] == "")
				{
					freqNum = 0;
				}
				else
				{
					freqArray = data[OBJ_NUM].split(SECOND_DELIMITER);
					freqNum = freqArray.length;
				}
				DrawTableRow("freqDataTable", "freqDataRow", "freqCaseRow", freqNum);
				if(freqNum != 0)
				{
					updateFreqTableData(freqArray);
				}
				if(data[OBJ_NUM + 1] == "")
				{
					plpNum = 0;
				}
				else
				{
					plpArray = data[OBJ_NUM + 1].split(SECOND_DELIMITER);
					plpNum = plpArray.length;
				}
				DrawTableRow("plpDataTable", "plpDataRow", "plpCaseRow", plpNum);
				if(plpNum != 0)
				{
					updatePlpTableData(plpArray);
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function updateFreqTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < freqNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(THIRD_DELIMITER);
		for(var j = 0; j < FREQ_COL_NUM; j++)
		{
			if(j == 0)
			{
				$("#" + freqIdArray[j] + index).html(index);
			}
			else
			{
				$("#" + freqIdArray[j] + index).html(rowData[j - 1]);
			}
		}
	}
}

function updatePlpTableData(data)
{
	var rowData;
	var index;
	var reserved = ["Reserved", "保留"];
	var plpType = ["Common PLP", "Data PLP Type1", "Data PLP Type2"];
	var codeRate = ["1/2", "3/5", "2/3", "3/4", "4/5", "5/6", "1/3", "2/5"];
	var modulation = ["QPSK", "16-QAM", "64-QAM", "256-QAM"];
	var timeIntervalEn = ["One T2-frame", "More than one T2-frame"];
	var timeIntervalCn = ["单T2帧", "多T2帧"];
	var timeInterval = [timeIntervalEn, timeIntervalCn];
	var plpModeEn = ["Not Appointed", "Normal Mode", "High Efficiency Mode", "Reserved"];
	var plpModeCn = ["未指定", "普通模式", "高效模式", "保留"];
	var plpMode = [plpModeEn, plpModeCn];
	var intData;
	
	for(var i = 0; i < plpNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(THIRD_DELIMITER);
		for(var j = 0; j < PLP_COL_NUM; j++)
		{
			intData = parseInt(rowData[j - 1], 10);
			if(j == 0)
			{
				$("#" + plpIdArray[j] + index).html(index);
			}
			else if(j == 2)
			{
				if(intData <= 2)
				{
					$("#" + plpIdArray[j] + index).html(plpType[intData]);
				}
				else
				{
					$("#" + plpIdArray[i] + index).html(reserved[language]);
				}
			}
			else if(j == 3)
			{
				$("#" + plpIdArray[j] + index).html(codeRate[intData]);
			}
			else if(j == 4)
			{
				if(intData <= 3)
				{
					$("#" + plpIdArray[j] + index).html(modulation[intData]);
				}
				else
				{
					$("#" + plpIdArray[i] + index).html(reserved[language]);
				}
			}
			else if(j == 6)
			{
				$("#" + plpIdArray[j] + index).html(timeInterval[language][intData]);
			}
			else if(j == 8)
			{
				$("#" + plpIdArray[j] + index).html(plpMode[language][intData]);
			}
			else
			{
				$("#" + plpIdArray[j] + index).html(rowData[j - 1]);
			}
		}
	}
}