var menuDisplay = false;
var zTree;
//设置配置参数 和 方法
var setting =
{
	editable: false,//参数设置为true便可使用拖拽功能
	edit_renameBtn:false,
	edit_removeBtn:false,
	dragCopy: true,//拖拽功能为复制然后在目的菜单添加
	dragMove: false,//拖拽功能为先删除然后在目的菜单添加
	data: {
		key: {
			children: "nodes"
		},
		simpleData: {
			enable : false,
			idKey : "id",
			pIdKey : "pId",
			rootPId : null
		}
	},
	view: {
		showLine: true,
		showTitle:false,
		showIcon:false,
		selectedMulti: false
	},
	callback: {
		onClick: treeOnClick,
		onRightClick: zTreeRightClick,
		beforeClick: zTreeBeforeClick
	}
};


function zTreeBeforeClick(treeId, treeNode, clickFlag)
{
	if(treeNode.noClick == true)
	{
		return false;
	}
	else
	{
		return true;
	} 
};

function treeOnClick(event, treeId, treeNode) 
{
	self.frames[0].location.replace(treeNode.href);
}

var selectNodeTop;
var selectNodeLeft;
var selectNodeWidth;
function zTreeRightClick(event, treeId, treeNode)
{
	var curBottomHeight;
	var curMenuHeight;
	if(treeNode.level == 0)
	{
		selectNodeTop = $("#" + treeNode.tId + "_span").offset().top;
		selectNodeLeft = $("#" + treeNode.tId + "_span").offset().left;
		selectNodeWidth = $("#" + treeNode.tId + "_span").width();
		
		curBottomHeight = $("#mainContent").height() - event.clientY;
		curMenuHeight = $("#plpMenu").height();
		
		zTree.selectNode(treeNode, false);
		if (curBottomHeight  < curMenuHeight)
		{
			$("#plpMenu").css({"top": event.clientY - (curMenuHeight - curBottomHeight) + "px", "left": (event.clientX + 10) + "px", "display": ""});
		}
		else
		{
			$("#plpMenu").css({"top": event.clientY + "px", "left": (event.clientX + 10) + "px", "display": ""});
		}
		menuDisplay = true;
	}
}

var rightIframeHeight;
function resizeHeight()
{
	var TREE_BLANK_HEIGHT = 66;
	var IFRAME_BLANK_HEIGHT = 45;

	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	$(".mux_tree_content").css("height", function(index, value)
	{
		return ((parent.iframeHeight - TREE_BLANK_HEIGHT) + "px");
	});	
	rightIframeHeight = parent.iframeHeight - IFRAME_BLANK_HEIGHT;
	$(".iframe").css("height", function(index, value)
	{
		return (rightIframeHeight + "px");
	});	
}

window.onresize = function()
{
	resizeHeight();
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	
	if(menuDisplay == true)
	{
		hideRightMenu();
	}
	document.body.onclick = function()
	{
		if(menuDisplay == true)
		{
			hideRightMenu();
		}
	}
	document.oncontextmenu = function()
	{
		if(menuDisplay == true)
		{
			hideRightMenu();
		}
	}
	
	resizeHeight();	
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	var selectNode;
	
	PageLoadStatus(true);
	
	zTree = $.fn.zTree.init($("#plpTree"), setting, zNodesInPsiPlp);
	selectNode = zTree.getNodeByParam("level", 1);
	if(selectNode != null)
	{
		zTree.selectNode(selectNode, false);
		self.frames[0].location.replace(selectNode.href);
	}
	
	PageLoadStatus(false);
}

function hideRightMenu()
{
	$("#plpMenu").css("display", "none");
}

function sendPsiSearchRequest()
{
	var data = "type=" + PORT_IN_PSI + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo;
	var xmlHttp = GetHTTPObject();
	var response;
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				$("#ajaxLoading").css({"top": selectNodeTop + "px", "left": selectNodeLeft + selectNodeWidth + 10 + "px", "display": "block"});
				setTimeout("getPortSearchFlag()", 2000);
			}
			else
			{
				alert(returnError[language][response]);
			}
		}
	}
	xmlHttp.send(data);
}

var SEARCHING = 1;
function getPortSearchFlag()
{
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_IN_PSI + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == SEARCHING)
			{
				setTimeout("getPortSearchFlag()", 2000);
			}
			else if(response == RETURN_OK)
			{
				self.location.reload(true);
			}
		}
	}
	xmlHttp.send(null);
}