﻿var objIdArray = ["outputSource", "packetLength", "alarmSwitch"];
var ROW_NUM = 3;

var option1Array = ["Replaced Stream", "替换流"];
var option2Array = ["Input Port 1", "输入端口1"];
var option3Array = ["Input Port 2", "输入端口2"];

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	portDisplay();
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function portDisplay()
{
	var option;
	var outputSource = $("#outputSource");
	
	if(portNo == 0)
	{
		$("#outputSourceTr").css("display", "none");
		$("#packetLengthTr").css("display", "");
	}
	else
	{
		if(portNo == 1)
		{
			outputSource.empty();
			option = $("<option>").text(option1Array[language]).val(0);
			outputSource.append(option);
			option = $("<option>").text(option2Array[language]).val(1);
			outputSource.append(option);

		}
		else
		{
			outputSource.empty();
			option = $("<option>").text(option1Array[language]).val(0);
			outputSource.append(option);
			option = $("<option>").text(option3Array[language]).val(2);
			outputSource.append(option);			
		}
		$("#outputSourceTr").css("display", "");
		$("#packetLengthTr").css("display", "none");
	}
}

function displayParam()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_OUT_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	data = "type=" + PORT_OUT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

