﻿var rowNum = 0;
var initRow = true;
var curRespRowNum;
var rowIndex;
var actionType;
var modifyRowIndex;

var objIdArray = ["name", "bissMode", "key", "idMode", "id"];
var editObjIdArray = ["editName", "editBissMode", "editKey", "editIdMode", "editId"];
var COL_NUM = 5;
var MODE_1 = 0;

var bissMode = ["Mode-1", "Mode-E"];
var idMode = ["Injected", "Buried"];

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	
	if(parent.groupAccess != USER)
	{
		$("input[type=checkbox]").live("click", function()
		{
			EnableButton("deleteBtn");
		});
	}
});

function funcUpdateDisplay() 
{		
	DisableButton("addBtn");
	DisableButton("deleteBtn");
	DisableButton("deleteAllBtn");
	DisableButton("refreshBtn");
	$("input[type=checkbox]").attr("disabled", true);
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
}

function displayParam() 
{
	var data;
	var response;
	var indexInfo;
	var curRowNum;
	
	var xmlHttp = GetHTTPObject();
	if(initRow)
	{
		rowIndex = 0;
	}

	xmlHttp.open("GET", "/goform/formEMR30?type=" + BISS_PARAM + "&cmd=" + GET + "&rowIndex=" + rowIndex +
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 1;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);
				curRowNum = $("#dataTable tr").filter(".CaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					DrawTableRow("dataTable", "dataRow", "CaseRow", rowIndex);
				}
				else if(curRowNum > rowNum)
				{
					DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				}
				if(curRespRowNum != 0)
				{
					updateTableData(data);
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					if(parent.groupAccess != USER)
					{
						EnableButton("addBtn");
						EnableButton("deleteAllBtn");
					}
					$("input[type=checkbox]").attr("disabled", false);
					$("#dataTable tr:even").addClass("even_bg_color");
					EnableButton("refreshBtn");
					initRow = true;
					refreshFlag = true;
				}
			}			
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = (rowIndex - curRespRowNum); i < rowIndex; i++)
	{
		index = i + 1;
		rowData = data[i - (rowIndex - curRespRowNum)].split(SECOND_DELIMITER);
		$("#index" + index).html(index);
		for(var j = 0; j < COL_NUM; j++)
		{
			if((j == 2) || (j == 4))
			{
				$("#" + objIdArray[j] + index).html(DISPLAY_STRING);
			}
			else if(j == 1)
			{
				$("#" + objIdArray[j] + index).html(bissMode[parseInt(rowData[j], 10)]);
			}
			else if(j == 3)
			{
				$("#" + objIdArray[j] + index).html(idMode[parseInt(rowData[j], 10)]);
			}
			else
			{
				$("#" + objIdArray[j] + index).html(rowData[j]);
			}
		}
	}
}

function checkAll()
{
	for(var i = 0; i < rowNum; i++)
	{
		$("#check" + (i + 1)).prop("checked", $("#checkAll").prop("checked"));
	}	
}

function addParam()
{
	actionType = ADD;
	$("#editName").val("");
	$("#editBissMode").val("0");
	$("#editKey").val("");
	$("#editIdMode").val("0");
	$("#editId").val("");
	$("#editId").attr("disabled", true);
	$("#editParam").modal();
}

function modifyParam(obj)
{
	actionType = SET;
	modifyRowIndex = GetIndexFromId(obj, 7);
	for(var i = 0; i < COL_NUM; i++)
	{
		$("#" + editObjIdArray[i]).val($("#" + objIdArray[i] + modifyRowIndex).html());
	}
	changeBissMode();
	$("#editParam").modal();
}

function editParamApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + BISS_PARAM + "&cmd=" + actionType + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	
	if(actionType == SET)
	{
		data += modifyRowIndex;
	}

	for(var i = 0; i < COL_NUM; i++)
	{
		if(i == (COL_NUM - 1))
		{
			if(parseInt($("#editBissMode").val(), 10) == MODE_1)
			{
				data += FIRST_DELIMITER + "00000000000000";
			}
			else
			{
				data += FIRST_DELIMITER + $("#" + editObjIdArray[i]).val();
			}
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + editObjIdArray[i]).val();
		}
	}
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					if(actionType == ADD)
					{
						alert("Param is added successfully!");
					}
					else if(actionType == SET)
					{
						alert("Param is modifyed successfully!");
					}
				}
				else if(language == CHINESE)
				{
					if(actionType == ADD)
					{
						alert("参数添加成功！");
					}
					else if(actionType == SET)
					{
						alert("参数成功修改！");
					}
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
	return true;
}

function paramCheck()
{
 	var returnFlag;
	var keyLength;
	var bissMode;

	returnFlag = ValidateName($("#editName"), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#editName"), "LENGTH", 0, 32, "<Name>", "<名称>", language);
	if(returnFlag == false)
	{
		return false;
	}
	bissMode = parseInt($("#editBissMode").val(), 10);
	if(bissMode == MODE_1)
	{
		keyLength = 12;
	}
	else
	{
		keyLength = 16;
	}
	returnFlag = ValidateParam($("#editKey"), "INT_HEX", 0, 0, "<Key>", "<密钥>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#editKey"), "LENGTH", keyLength, keyLength, "<Key>", "<密钥>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(bissMode != MODE_1)
	{
		returnFlag = ValidateParam($("#editId"), "INT_HEX", 0, 0, "<ID>", "<ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#editId"), "LENGTH", 14, 14, "<ID>", "<ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}


function cancelEdit()
{
	$.modal.close();
}

function deleteParam()
{
	var data;
	var index;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deleteParamIndex = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the selected Param?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中参数吗？";
	}
	
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + BISS_PARAM + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
		
		for(var i = 0; i < rowNum; i++)
		{
			index = i + 1;
			if($("#check" + index).prop("checked") == true)
			{
				if(deleteNum == 0)
				{
					deleteParamIndex = index;
				}
				else
				{
					deleteParamIndex += FIRST_DELIMITER + index;
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one Param at least!");
			}
			else
			{
				alert("请至少选中一个参数！");
			}
			return;
		}
		data += deleteParamIndex;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The checked Param are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("选中参数删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function deleteAll()
{
	var confirmPrompt;
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(rowNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("The Param number is 0!");
		}
		else if(language == CHINESE)
		{
			alert("参数个数是0！");
		}
		return;
	}
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all the Param?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除全部参数吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + BISS_PARAM + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=0xffff";
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("Param are all deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("所有参数删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function changeBissMode()
{
	var bissMode = parseInt($("#editBissMode").val(), 10);
	if(bissMode == MODE_1)
	{
		$("#editId").attr("disabled", true);
	}
	else
	{
		$("#editId").attr("disabled", false);
	}
}