﻿var progIdArray = ["serviceId", "serviceName", "camSelect", "descramStatus"];
var PROG_COL_NUM = 4;
var pidIdArray = ["check", "pidStr", "key", "pidStatus"];
var PID_COL_NUM = 4;
var progNum;
var pidNum = [];
var showString = ["Show Detail", "显示详细"];
var hiddenString = ["Hidden Detail", "隐藏详细"];
var descrambStatusEn = ["No Descramble", "Descrambling Failure", "Descrambling Success"];
var descrambStatusCn = ["未解扰", "解扰失败", "解扰成功"];
var descrambStatus = [descrambStatusEn, descrambStatusCn];
var keySelectMode;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	setInterval("getStatus();", 3000);
	$("input[type=checkbox]").live("click", function()
	{
		EnableButton("applyBtn");
	});
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

var keyName = [];
function displayParam()
{
	var data;
	var secondData;
	var length;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + BISS_PROG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response == "")
			{
				progNum = 0;
			}
			else
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				progNum = length - 2;
				if(data[progNum] != "null")
				{
					keyName = data[progNum].split(SECOND_DELIMITER);
				}
				keySelectMode = parseInt(data[progNum + 1], 10);
			}
			DrawTableTwoRow("dataTable", "progDataRow", "progCaseRow", "pidDataRow", "pidCaseRow", progNum);
			for(var i = 0; i < progNum; i++)
			{
				secondData = data[i].split(SECOND_DELIMITER);
				length = secondData.length;
				pidNum.push(length - 1);
				DrawTableRow("pidTable" + (i + 1), "pidRow", "PidRow", pidNum[i]);
			}
			if(progNum != 0)
			{
				if(keyName.length != 0)
				{
					updateKeyOption();
				}
				updateTableData(data);
			}
			refreshFlag = true;  //刷新标识符设为true表示刷新成功
		}
	}
	xmlHttp.send(null);
}

function updateKeyOption()
{
	var length = keyName.length;
	var key;
	var option;
	for(var i = 0; i < progNum; i++)
	{
		for(var j = 0; j < pidNum[i]; j++)
		{
			key = $("#pidTable" + (i + 1) + " #key" + (j + 1));
			key.empty();
			for(var k = 0; k < length; k++)
			{
				option = $("<option>").text(keyName[k]).val(k);
				key.append(option);	
			}
		}
	}
}

function getStatus()
{
	var data;
	var secondData;
	var curProgNum;
	var curPidNum;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + BISS_PROG_STATUS + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response == "")
			{
				curProgNum = 0;
			}
			else
			{
				data = response.split(FIRST_DELIMITER);
				curProgNum = data.length;
			}
			if(curProgNum != progNum)
			{
				self.location.replace("biss_prog" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
				return;
			}
			for(var i = 0; i < progNum; i++)
			{
				secondData = data[i].split(SECOND_DELIMITER);
				curPidNum = secondData.length - 1;
				$("#descramStatus" + (i + 1)).html(descrambStatus[language][parseInt(secondData[0], 10)]);
				changeFontColor($("#descramStatus" + (i + 1)), parseInt(secondData[0], 10));
				if(curPidNum != pidNum[i])
				{
					self.location.replace("biss_prog" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
					return;
				}
				for(var j = 0; j < pidNum[i]; j++)
				{
					$("#pidTable" + (i + 1) + " #pidStatus" + (j + 1)).html(descrambStatus[language][parseInt(secondData[j + 1], 10)]);
					changeFontColor($("#pidTable" + (i + 1) + " #pidStatus" + (j + 1)), parseInt(secondData[j + 1], 10));
				}
			}
		}
	}
	xmlHttp.send(null);
}

function changeFontColor(obj, value)
{
	if(value == 1)
	{
		obj.css("color", "red");
	}
	else if(value == 2)
	{
		obj.css("color", "green");
	}
	else
	{
		obj.css("color", "black");
	}
}

function updateTableData(data)
{
	var secondData;
	var progData;
	var pidData;
	
	for(var i = 0; i < progNum; i++)
	{
		secondData = data[i].split(SECOND_DELIMITER);
		progData = secondData[0].split(THIRD_DELIMITER);
		for(var j = 0; j < PROG_COL_NUM; j++)
		{
			if(j == 2)
			{
				$("#" + progIdArray[j] + (i + 1)).val(progData[j]);
			}
			else if(j == 3)
			{
				$("#" + progIdArray[j] + (i + 1)).html(descrambStatus[language][parseInt(progData[j], 10)]);
				changeFontColor($("#" + progIdArray[j] + (i + 1)), parseInt(progData[j], 10));
			}
			else
			{
				$("#" + progIdArray[j] + (i + 1)).html(progData[j]);
			}
		}
		for(var j = 0; j < pidNum[i]; j++)
		{
			pidData = secondData[j + 1].split(THIRD_DELIMITER);
			for(var k = 0; k < PID_COL_NUM; k++)
			{
				if(k == 0)
				{
					if(parseInt(pidData[k], 10) == 1)
					{
						$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).prop("checked", true);
					}
					else
					{
						$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).prop("checked", false);
					}
				}
				else if(k == 1)
				{
					$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).html(pidData[k]);
				}
				else if(k == 3)
				{
					$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).html(descrambStatus[language][parseInt(pidData[k], 10)]);
					changeFontColor($("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)), parseInt(pidData[k], 10));
				}
				else
				{
					$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).val(pidData[k]);
				}
			}
		}
	}
	
	for(var i = 0; i < progNum; i++)
	{
		$("#pidDataRow" + (i + 1)).css("display", "none");
	}
	$("#detailBtn").val(showString[language]);
	display = false;
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	data = "type=" + BISS_PROG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	
	for(var i = 0; i < progNum; i++)
	{
		if(i == 0)
		{
			data = $("#camSelect" + (i + 1)).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#camSelect" + (i + 1)).val();
		}
		for(var j = 0; j < pidNum[i]; j++)
		{
			if($("#pidTable" + (i + 1) + " #check" + (j + 1)).prop("checked") == true)
			{
				data += SECOND_DELIMITER + 1;
			}
			else
			{
				data += SECOND_DELIMITER + 0;
			}
			data += THIRD_DELIMITER + parseInt($("#pidTable" + (i + 1) + " #key" + (j + 1)).val(), 10);
		}
	}
	
	return data;
}

var display = false;
function displayDetail()
{
	if(display == false)
	{
		for(var i = 0; i < progNum; i++)
		{
			$("#pidDataRow" + (i + 1)).css("display", "");
		}
		$("#detailBtn").val(hiddenString[language]);
		display = true;
	}
	else
	{
		for(var i = 0; i < progNum; i++)
		{
			$("#pidDataRow" + (i + 1)).css("display", "none");
		}
		$("#detailBtn").val(showString[language]);
		display = false;
	}
}

function changeCam(obj)
{
	var index = obj.attr("id").slice(9) - 1;
	if(parseInt(obj.val(), 10) == 0)
	{
		for(var i = 0; i < pidNum[index]; i++)
		{
			$("#pidTable" + (index + 1) + " #check" + (i + 1)).prop("checked", false);
		}
	}
	else
	{
		for(var i = 0; i < pidNum[index]; i++)
		{
			$("#pidTable" + (index + 1) + " #check" + (i + 1)).prop("checked", true);
		}
	}
}

function changeKey(obj)
{
	var pidTable;
	var index;
	if(keySelectMode == 0)
	{
		for(var i = 0; i < progNum; i++)
		{
			for(var j = 0; j < pidNum[i]; j++)
			{
				$("#pidTable" + (i + 1) + " #key" + (j + 1)).val(obj.val());
				$("#pidTable" + (i + 1) + " #key" + (j + 1)).css("background-color", "#feffe0");
			}
		}
	}
	else if(keySelectMode == 1)
	{
		pidTable = obj.parent().parent().parent().parent();
		index = pidTable.attr("id").slice(8) - 1;
		for(var i = 0; i < pidNum[index]; i++)
		{
			pidTable.find("#key" + (i + 1)).val(obj.val());	
			pidTable.find("#key" + (i + 1)).css("background-color", "#feffe0");
		}
	}
}