﻿var objIdArray = ["tunerSwitch", "standard", "tsChangeSwitch", "22khzSwitch", "polarize", "diseqc", "search", "symbolRate", "localFrequency", "downFrequency", "appointedPid"];
var ROW_NUM = 11;
var POLARIZE_OFF = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + RF_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				disableParam($("#polarize"));
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + RF_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function disableParam(obj)
{
	var curPolarize = parseInt(obj.val(), 10);
	if(curPolarize == POLARIZE_OFF)
	{
		$("#diseqc").attr("disabled", true);
	}
	else
	{
		$("#diseqc").attr("disabled", false);
	}
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var differenceValue;
		
	returnFlag = ValidateParam($("#symbolRate"), "INT_DEC", 1000, 45000, "<Symbol Rate(Ksps)>", "<符号率(Ksps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#localFrequency"), "INT_DEC", 1, 99999, "<Local Frequency(MHz)>", "<本振频率(MHz)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#downFrequency"), "INT_DEC", 1, 99999, "<Downlink Frequency(MHz)>", "<下行频率(MHz)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	differenceValue = parseInt($("#downFrequency").val(), 10) - parseInt($("#localFrequency").val(), 10);
	if((Math.abs(differenceValue) < 950) || (Math.abs(differenceValue) > 2150))
	{
		if(language == ENGLISH)
		{
			alert("The absolute value of the difference between downlink frequency and local frequency must be between 950 and 2150!");
		}
		else
		{
			alert("下行频率和本振频率的差值的绝对值必须在950和2150之间！");
		}		
		return false;
	}
	returnFlag = ValidateParam($("#appointedPid"), "INT_DEC_HEX", 0, 8191, "<Appointed PID>", "<指定PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;	return true;
}