﻿var rowNum;

var objIdArray = ["id", "switch", "refRate", "refSwitch"];
var COL_NUM = 4;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	AddTabMouseAction("pidConfig");
	AddTabMouseAction("monitor");
});

function funcUpdateDisplay() 
{		
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + T2MI_PLP + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{			
				data = response.split(FIRST_DELIMITER);
				rowNum = data.length;			
				DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				if(rowNum != 0)
				{
					updateTableData(data);
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(SECOND_DELIMITER);
		$("#index" + index).html(index);
		for(var j = 0; j < COL_NUM; j++)
		{
			$("#" + objIdArray[j] + index).val(rowData[j]);
		}
	}
}

function pageApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + T2MI_PLP + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
	return true;
}

function generateData()
{
	var data;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		for(var j = 0; j < COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[j] + index).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[j] + index).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[j] + index).val();
			}
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		returnFlag = ValidateParam($("#id" + index), "INT_DEC", 0, 255, "<PLP_ID>", "<PLP_ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#refRate" + index), "INT_DEC", 0, 213000000, "<Reference Bitrate (bps)>", "<基准码率 (bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}
