﻿var rowNum;
var freqNum;
var plpNum;

var commonIdTable = ["guardInterval", "constellation", "pilotPattern", "networkId", "systemId", "version", "freqAmount", "plpAmount"];
var COMMON_COL_NUM = 8;

var freqIdArray = ["freqRowIndex", "freqIndex", "freqValue"];
var FREQ_COL_NUM = 3;

var plpIdTable = ["plpId", "plpType", "codeRate", "modulation", "frameInterval", "timeIntervalType", "timeIntervalLength", "plpMode", "plpBlockNum"];
var PLP_COL_NUM = 9;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	AddTabMouseAction("pidConfig");
	AddTabMouseAction("plpConfig");
});

function funcUpdateDisplay() 
{		
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var guardInterval = ["1/32", "1/16", "1/8", "1/4", "1/128", "19/128", "19/256", "Reserved", "--"];
	var constellation = ["BPSK", "QPSK", "16-QAM", "64-QAM", "Reserved", "--"];
	var pilotPattern = ["PP1", "PP2", "PP3", "PP4", "PP5", "PP6", "PP7", "PP8", "--"];
	var version = ["1.1.1", "1.2.1", "1.3.1", "Reserved", "--"];
	var reserved = ["Reserved", "保留"];
	var staticParam = [guardInterval, constellation, pilotPattern, "", "", version, "", ""];
	var data;
	var response;
	var freqArray;
	var plpArray;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + T2MI_MONITOR + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{		
				data = response.split(FIRST_DELIMITER);	
				if((data[6] == 0) && (data[7] == 0))
				{
					$("#commonParamTr").css("display", "none");
				}
				else
				{
					$("#commonParamTr").css("display", "");
				}
				for(var i = 0; i < COMMON_COL_NUM; i++)
				{
					if(i == 0)
					{
						if(data[i] == 7)
						{
							$("#" + commonIdTable[i]).html(reserved[language]);
						}
						else
						{
							$("#" + commonIdTable[i]).html(staticParam[i][data[i]]);
						}
					}
					else if(i == 1)
					{
						if(data[i] == 4)
						{
							$("#" + commonIdTable[i]).html(reserved[language]);
						}
						else
						{
							$("#" + commonIdTable[i]).html(staticParam[i][data[i]]);
						}
					}
					else if(i == 2)
					{

						$("#" + commonIdTable[i]).html(staticParam[i][data[i]]);
					}
					else if(i == 5)
					{
						if(data[i] == 3)
						{
							$("#" + commonIdTable[i]).html(reserved[language]);
						}
						else
						{
							$("#" + commonIdTable[i]).html(staticParam[i][data[i]]);
						}
					}
					else
					{
						$("#" + commonIdTable[i]).html(data[i]);
					}
				}
				if(data[COMMON_COL_NUM] == "")
				{
					freqNum = 0;
				}
				else
				{
					freqArray = data[COMMON_COL_NUM].split(SECOND_DELIMITER);
					freqNum = freqArray.length;
				}
				DrawTableRow("freqDataTable", "freqDataRow", "freqCaseRow", freqNum);
				if(freqNum != 0)
				{
					updateFreqTableData(freqArray);
				}
				if(data[COMMON_COL_NUM + 1] == "")
				{
					plpNum = 0;
				}
				else
				{
					plpArray = data[COMMON_COL_NUM + 1].split(SECOND_DELIMITER);
					plpNum = plpArray.length;
				}
				DrawTableRow("plpDataTable", "plpDataRow", "plpCaseRow", plpNum);
				if(plpNum != 0)
				{
					updatePlpTableData(plpArray);
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function updateFreqTableData(data)
{
	var rowData;
	var index;	
	for(var i = 0; i < freqNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(THIRD_DELIMITER);
		for(var j = 0; j < FREQ_COL_NUM; j++)
		{
			if(j == 0)
			{
				$("#" + freqIdArray[j] + index).html(index);
			}
			else
			{
				$("#" + freqIdArray[j] + index).html(rowData[j - 1]);
			}
		}
	}
}

function updatePlpTableData(data)
{
	var plpTypeEn = ["Common", "Type1", "Type2", "Reserved"];
	var plpTypeCn = ["共用的", "类型1", "类型2", "保留"];
	var codeRate = ["1/2", "3/5", "2/3", "3/4", "4/5", "5/6", "1/3", "2/5"];
	var modulationEn = ["QPSK", "16-QAM", "64-QAM", "256-QAM", "Reserved"];
	var modulationCn = ["QPSK", "16-QAM", "64-QAM", "256-QAM", "保留"];
	var intervalTypeEn = ["One T2-Frame", "More Than One"];
	var intervalTypeCn = ["单T2帧", "多T2帧"];
	var plpModeEn = ["N/A", "Normal Mode", "HE Mode", "Reserved"];
	var plpModeCn = ["未指定", "普通模式", "高效模式", "保留"];
	var dynamicParamEn = ["", plpTypeEn, codeRate, modulationEn, "", intervalTypeEn, "", plpModeEn, ""];
	var dynamicParamCn = ["", plpTypeCn, codeRate, modulationCn, "", intervalTypeCn, "", plpModeCn, ""];
	var dynamicParam = [dynamicParamEn, dynamicParamCn];
	var rowData;
	var index;
	
	for(var i = 0; i < plpNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(THIRD_DELIMITER);
		for(var j = 0; j < PLP_COL_NUM; j++)
		{
			$("#plpIndex" + index).html(index);
			if(dynamicParam[language][j] == "")
			{
				$("#" + plpIdTable[j] + index).html(rowData[j]);			
			}
			else
			{
				$("#" + plpIdTable[j] + index).html(dynamicParam[language][j][rowData[j]]);
			}
		}
	}
}