﻿var generalIdArray = ["decodeSwitch", "syncMode", "errHandle"];
var progDecodeIdArray = ["service", "pcrPid", "videoPid", "audioPid", "ttPid"];
var videoDecodeIdArray = ["videoPattern", "aspectRatio", "imageScaling"];
var audioDecodeIdArray = ["outMute", "vol", "audioMode"];
var vbiIdArray = ["ccSwitch", "ccDelay"];
var objIdArray = [generalIdArray, progDecodeIdArray, videoDecodeIdArray, audioDecodeIdArray, vbiIdArray];
var SEC_NUM = 5;

var serviceName;
var serviceNum;

var NO_SERVICE = -1;
var CUSTOM = 32;
var noServiceList = ["None", "无节目"];
var customList = ["Custom", "自定义"];

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				if(data[SEC_NUM] == "")
				{
					serviceNum = 0;
				}
				else
				{
					serviceName = data[SEC_NUM].split(SECOND_DELIMITER);
					serviceNum = serviceName.length;
				}
				generateService();
				for(var i = 0; i < SEC_NUM; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					length = sectionData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(sectionData[j]);
					}
				}
				changeDecMode();
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function generateService()
{
	var service = $("#service");
	var option;
	
	service.empty();	
	if(serviceNum == 0)
	{
		option = $("<option>").text(noServiceList[language]).val(NO_SERVICE);
		service.append(option);
	}
	else
	{
		for(var i = 0; i < serviceNum; i++)
		{
			option = $("<option>").text(serviceName[i]).val(i);
			service.append(option);
		}
		option = $("<option>").text(customList[language]).val(CUSTOM);
		service.append(option);
	}
}

function changeDecMode()
{
	var decodeMode = parseInt($("#service").val(), 10);
	
	if(decodeMode == CUSTOM)
	{
		$("#pcrPid").attr("disabled", false);
		$("#videoPid").attr("disabled", false);
		$("#audioPid").attr("disabled", false);
		$("#ttPid").attr("disabled", false);
	} 
	else
	{
		$("#pcrPid").attr("disabled", true);
		$("#videoPid").attr("disabled", true);
		$("#audioPid").attr("disabled", true);
		$("#ttPid").attr("disabled", true);
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	var decodeMode = parseInt($("#service").val(), 10);
	
	returnFlag = ValidateParam($("#ccDelay"), "INT_DEC", 1, 25, "<CC Delay>", "<CC延时输出>", language);
	if(returnFlag == false)
	{
		return false;
	}
		
	if(decodeMode == CUSTOM)
	{
		returnFlag = ValidateParam($("#pcrPid"), "INT_DEC_HEX", 0, 8191, "<Decode PCR PID>", "<解码PCR PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#videoPid"), "INT_DEC_HEX", 0, 8191, "<Decode Video PID>", "<解码视频PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#audioPid"), "INT_DEC_HEX", 0, 8191, "<Decode Audio PID>", "<解码音频PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#ttPid"), "INT_DEC_HEX", 0, 8191, "<Teletext PID>", "<解码TT PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	
	returnFlag = ValidateParam($("#vol"), "INT_DEC", 0, 30, "<Vol Attenuation>", "<输出音量衰减>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < SEC_NUM; i++)
	{
		length = objIdArray[i].length;
		for(var j = 0; j < length; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[i][j]).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
		}
	}
	
	return data;
}