﻿var objIdArray = ["bissMode", "key", "idMode", "id", "serviceId", "keySelect"];
var ROW_NUM = 8;
var COL_NUM = 6;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var rowData;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_BISS_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					rowData = data[i].split(SECOND_DELIMITER);
					for(var j = 0; j < COL_NUM; j++)
					{
						$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
					}
				}
				$("#keySwitch").val(data[ROW_NUM]);
				$("#descrambSwitch").val(data[ROW_NUM + 1]);
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CARD_BISS_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	var index;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		index = i + 1;
		returnFlag = ValidateParam($("#key" + index), "LENGTH", 12, 16, "<Key>", "<密钥>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#id" + index), "LENGTH", 12, 16, "<ID>", "<ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#serviceId" + index), "INT_DEC_HEX", 0, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}	
	}
	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		for(var j = 0; j < COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[j] + (i + 1)).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
		}
	}
	
	data += FIRST_DELIMITER + $("#keySwitch").val() + FIRST_DELIMITER + $("#descrambSwitch").val();
	
	return data;
}

