﻿var objIdArray = ["serviceId", "serviceName", "pcrPid"];
var COL_NUM = 3;
var PCR_PID = 2;
var rowNum;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{		
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var rowData;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_PCR + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);			
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				rowNum = data.length;
				DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				updateTableData(data);			
			}
			refreshFlag = true;
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			if(j == PCR_PID)
			{
				$("#" + objIdArray[j] + index).val(rowData[j]);
			}
			else
			{
				$("#" + objIdArray[j] + index).html(rowData[j]);
			}				
		}
	}
}

function pageApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(paramCheck() == false)
	{
		return;
	}

	data = "type=" + PORT_PCR + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";		
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true);
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText));
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
	var returnFlag;
	var index;
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		returnFlag = ValidateParam($("#pcrPid" + index), "INT_DEC_HEX", 32, 8191, "<PCR PID>", "<PCR PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

function generateData()
{
	var data;
	var rowData;

	var index;
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		if(i == 0)
		{
			data = $("#pcrPid" + index).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#pcrPid" + index).val();
		}
	}
	return data;
}