﻿var objIdArray = ["ipAddress", "subnetMask", "gateWay", "mac", "speedDuplex", "alarmSwitch", "igmpVersion"];
var COL_NUM = 7;
var ROW_NUM = 4;
var MAC_ADDR = 3;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var rowData;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					rowData = data[i].split(SECOND_DELIMITER);
					for(var j = 0; j < COL_NUM; j++)
					{
						if(j == MAC_ADDR)
						{
							$("#" + objIdArray[j] + (i + 1)).html(rowData[j]);
						}
						$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
					}
								
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CARD_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var rowData;
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		for(var j = 0; j < COL_NUM; j++)
		{
			if(j == MAC_ADDR)
			{
				continue;
			}
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[j] + (i + 1)).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		returnFlag = ValidateIP($("#ipAddress" + (i + 1)), "UNICAST_IP_ADDR", "<IP Address>", "<IP地址>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		returnFlag = ValidateIP($("#subnetMask" + (i + 1)), "SUBNET_MASK", "<Subnet Mask>", "<子网掩码>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateSubnetMaskRelation($("#ipAddress" + (i + 1)).val(), $("#subnetMask" + (i + 1)), "<Subnet Mask>", "<子网掩码>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		returnFlag = ValidateIP($("#gateWay" + (i + 1)), "GATEWAY", "<Gateway>", "<网关>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateGatewayRelation($("#ipAddress" + (i + 1)).val(), $("#subnetMask" + (i + 1)).val(), $("#gateWay" + (i + 1)), "<Gateway>", "<网关>", language)
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}
