﻿var pairIdArray = ["backupSwitch", "backupMode", "switchCondition", "minRate1", "maxRate1", "minRate2", "maxRate2"];
//var pair2IdArray = ["backupSwitch2", "backupMode2", "switchCondition2", "minRate2", "maxRate2", "minRate4", "maxRate4"];
//var pairArray = [pair1IdArray, pair2IdArray];
var getBackupSwitch = new Array();
var PAIR_NUM = 2;
var PAIR_GBE_NUM = 2;
var PARAM_NUM = 7;
var PAIR1 = 1;  //pair1 
var PAIR2 = 2;  //pair2
var THRESHOLD = 3;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);	
	funcUpdateDisplay();
	
	for(var i = 0; i < PAIR_NUM; i++)
	{
		$("#backupSwitch" + (i + 1)).bind("change", function()
		{
			enablePairParam($(this));
		});
		$("#switchCondition" + (i + 1)).bind("change", function()
		{
			displayBitrate($(this));
		});
	}
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var sectionData;
	var data;
	var length;
	var pairData;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_IN_BACKUP + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 1], 10);
				displayPair();
				for(var i = 0; i < PAIR_NUM; i++)
				{
					pairData = data[i].split(SECOND_DELIMITER);
					for(var j = 0; j < PARAM_NUM; j++)
					{
						$("#" + pairIdArray[j] + (i + 1)).val(pairData[j]);
					}
					getBackupSwitch[i] = pairData[0];
					enablePairParam($("#backupSwitch" + (i + 1)));
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

/*************************************************
Function: 		displayPair
Description: 	用于根据授权动态改变组2的显示
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function displayPair()
{
	if(identifyData == ONE_LICENSE)
	{
		$("#pair2").css("display", "none");
	}
	else
	{	
		$("#pair2").css("display", "");
	}	
}

/*************************************************
Function: 		displayBitrate
Description: 	用于动态改变页隐藏的码率设置参数
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function displayBitrate(obj)
{
	var index = obj.attr("id").slice(15);
	if(parseInt(obj.val(), 10) == THRESHOLD)
	{
		$("#pairBitrate" + index).css("display", "");
	}
	else
	{	
		$("#pairBitrate" + index).css("display", "none");
	}	
}

/*************************************************
Function: 		enablePairParam
Description: 	用于动态改变页面变灰和隐藏的参数
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function enablePairParam(obj)
{	
	var index = obj.attr("id").slice(12);
	if(parseInt(obj.val(), 10) == ON)
	{
		$("#backupMode" + index).attr("disabled", false);
		$("#switchCondition" + index).attr("disabled", false);
		displayBitrate($("#switchCondition" + index));
	}
	else
	{	
		$("#backupMode" + index).attr("disabled", true);
		$("#switchCondition" + index).attr("disabled", true);
		$("#pairBitrate" + index).css("display", "none");
	}
}

function sendRequest(url)
{
	var tId = parent.curTree.getSelectedNodes()[0].tId;
	var selectNode;
	var xmlHttp = GetHTTPObject();
	xmlHttp.open("GET", url, true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			ExecuteScript(xmlHttp.responseText);
			selectNode = parent.curTree.getNodeByTId(tId);
			parent.curTree.selectNode(parent.curTree.getNodeByTId(tId));
		}
	}
	xmlHttp.send(null);
}
/*************************************************
Function: 		changeBackupSwitch
Description: 	用于备份开关改变时重新加载左边树
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeBackupSwitch()
{	
	for(var i = 0; i < PAIR_NUM; i++)
	{
		if(parseInt($("#backupSwitch" + (i + 1)).val(), 10) != getBackupSwitch[i])
		{
			sendRequest("../frame" + pageLanguage[language] + "?ran=" + Math.random());
		}
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type="+ CARD_IN_BACKUP + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			changeBackupSwitch();
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function checkBitarate(index)
{
	var returnFlag;
	var minRate;
	var maxRate;
	
	for(var i = 0; i < PAIR_GBE_NUM; i++)
	{
		minRate = parseInt($("#minRate" + (i + 1) + index).val(), 10);
		maxRate = parseInt($("#maxRate" + (i + 1) + index).val(), 10);
		
		returnFlag = ValidateParam($("#minRate" + (i + 1) + index), "INT_DEC", 0, 1000000000, "<Min Effective Rate Threshold(bps)>", "<最小有效码率阈值(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		returnFlag = ValidateParam($("#maxRate" + (i + 1) + index), "INT_DEC", 0, 1000000000, "<Max Effective Rate Threshold(bps)>", "<最大有效码率阈值(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		if(minRate > maxRate)
		{
			if(language == ENGLISH)
			{
				alert("Min effective rate threshold cannot be larger than max effective rate threshold!");
			}
			else
			{
				alert("最小码率阈值不得大于最大码率阈值！");
			}			
			return false;
		}
	}
	return true;
}

function paramCheck()
{
	var backupSwitch1 = parseInt($("#backupSwitch1").val(), 10);
	var switchCondition1 = parseInt($("#switchCondition1").val(), 10);
	var backupSwitch2 = parseInt($("#backupSwitch2").val(), 10);
	var switchCondition2 = parseInt($("#switchCondition2").val(), 10);
	
	if((backupSwitch1 == ON) && (switchCondition1 == THRESHOLD))
	{
		if(checkBitarate(PAIR1) == false)
		{
			return false;
		}
	}
	if((backupSwitch2 == ON) && (switchCondition2 == THRESHOLD))
	{
		if(checkBitarate(PAIR2) == false)
		{
			return false;
		}
	}
	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < PAIR_NUM; i++)
	{
		for(var j = 0; j < PARAM_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + pairIdArray[j] + (i + 1)).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + pairIdArray[j] + (i + 1)).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + pairIdArray[j] + (i + 1)).val();
			}
		}
	}
	return data;
}