﻿var rowNum = 0;
var initRow = true;
var curRespRowNum;
var rowIndex;
var actionType;
var modifyRowIndex;

var objIdArray = ["index", "ip", "mac"];
var COL_NUM = 3;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	displayMenu();
	funcUpdateDisplay();
	AddTabMouseAction("dynamic");
	
	if(parent.groupAccess != USER)
	{
		$("input[type=checkbox]").live("click", function()
		{
			EnableButton("deleteBtn");
		});
	}
});

function funcUpdateDisplay() 
{		
	DisableButton("addBtn");
	DisableButton("deleteBtn");
	DisableButton("deleteAllBtn");
	DisableButton("refreshBtn");
	$("input[type=checkbox]").attr("disabled", true);
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
}

function displayParam() 
{
	var data;
	var response;
	var indexInfo;
	var curRowNum;
	
	var xmlHttp = GetHTTPObject();
	if(initRow)
	{
		rowIndex = 0;
	}

	xmlHttp.open("GET", "/goform/formEMR30?type=" + GBE_ARP_CONFIG + "&cmd=" + GET + "&rowIndex=" + rowIndex +
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 1;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);
				curRowNum = $("#dataTable tr").filter(".CaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					DrawTableRow("dataTable", "dataRow", "CaseRow", rowIndex);
				}
				else if(curRowNum > rowNum)
				{
					DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				}
				if(curRespRowNum != 0)
				{
					updateTableData(data);
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					if(parent.groupAccess != USER)
					{
						EnableButton("addBtn");
						EnableButton("deleteAllBtn");
					}
					$("input[type=checkbox]").attr("disabled", false);
					$("#dataTable tr:even").addClass("even_bg_color");
					EnableButton("refreshBtn");
					initRow = true;
					refreshFlag = true;
				}
			}			
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = (rowIndex - curRespRowNum); i < rowIndex; i++)
	{
		index = i + 1;
		rowData = data[i - (rowIndex - curRespRowNum)].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			if(j == 0)
			{
				$("#" + objIdArray[j] + index).html(index);
			}
			else
			{
				$("#" + objIdArray[j] + index).html(rowData[j - 1]);
			}
		}
	}
}

function checkAll()
{
	for(var i = 0; i < rowNum; i++)
	{
		$("#check" + (i + 1)).prop("checked", $("#checkAll").prop("checked"));
	}	
}

function addArp()
{
	actionType = ADD;
	$("#editIp").val("");
	for(var i = 0; i < 6; i++)
	{
		$("#editMac" + (i + 1)).val("");
	}
	$("#editArp").modal();
}

function modifyArp(obj)
{
	actionType = SET;
	modifyRowIndex = GetIndexFromId(obj, 7);
	$("#editIp").val($("#ip" + modifyRowIndex).html());
	var macAddr = $("#mac" + modifyRowIndex).html().split(":");
	for(var i = 0; i < 6; i++)
	{
		$("#editMac" + (i + 1)).val(macAddr[i]);
	}
	$("#editArp").modal();
}

function editMac(obj)
{
	var index = parseInt(obj.attr("id").slice(7), 10);
	if(obj.val().length == 2)
	{
		setTimeout(function () {$("#editMac" + (index + 1)).focus()}, 0);
		setTimeout(function () {$("#editMac" + (index + 1)).select()}, 0);
	}
}

function editArpApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	var macArr = [];
 	var returnFlag;
	var editMac;
	
	returnFlag = ValidateIP($("#editIp"), "UNICAST_IP_ADDR", "<ARP IP Address>", "<ARP IP地址>", language);
	if(returnFlag == false)
	{
		return false;
	}
	for(var i = 0; i < 6; i++)
	{
		returnFlag = ValidateParam($("#editMac" + (i + 1)), "INT_HEX", 0, 0, "<ARP MAC>", "<ARP MAC>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#editMac" + (i + 1)), "LENGTH", 2, 2, "<ARP MAC>", "<ARP MAC>", language);
		if(returnFlag == false)
		{
			return false;
		}
		macArr.push($("#editMac" + (i + 1)).val());
	}
	editMac = macArr.join(":");
	if((actionType == ADD) || ((actionType == SET) && (IPCompare($("#editIp").val(), $("#ip" + modifyRowIndex).html()) == false)))
	{
		for(var i = 0; i < rowNum; i++)
		{
			if(IPCompare($("#editIp").val(), $("#ip" + (i + 1)).html()) == true)
			{			
				if(language == ENGLISH)
				{
					alert("Destination IP already exists!");
				}
				else
				{
					alert("目的IP地址已经存在！");
				}
				return false;
			}
		}
	}
	if((actionType == ADD) || ((actionType == SET) && (editMac != $("#mac" + modifyRowIndex).html())))
	{
		for(var i = 0; i < rowNum; i++)
		{
			if(editMac == $("#mac" + (i + 1)).html())
			{
				if(language == ENGLISH)
				{
					alert("Destination MAC already exists!");
				}
				else
				{
					alert("目的MAC地址已经存在！");
				}
				return false;
			}
		}
	}
	data = "type=" + GBE_ARP_CONFIG + "&cmd=" + actionType + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	
	if(actionType == SET)
	{
		data += modifyRowIndex + FIRST_DELIMITER;
	}

	data += $("#editIp").val();
	
	for(var i = 0; i < 6; i++)
	{
		data += FIRST_DELIMITER + "0x" + $("#editMac" + (i + 1)).val();
	}
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					if(actionType == ADD)
					{
						alert("ARP is added successfully!");
					}
					else if(actionType == SET)
					{
						alert("ARP is modifyed successfully!");
					}
				}
				else if(language == CHINESE)
				{
					if(actionType == ADD)
					{
						alert("ARP添加成功！");
					}
					else if(actionType == SET)
					{
						alert("ARP成功修改！");
					}
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
	return true;
}

function cancelEdit()
{
	$.modal.close();
}

function deleteArp()
{
	var data;
	var index;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deleteArpIndex = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the selected ARP?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中ARP吗？";
	}
	
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + GBE_ARP_CONFIG + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
		
		for(var i = 0; i < rowNum; i++)
		{
			index = i + 1;
			if($("#check" + index).prop("checked") == true)
			{
				if(deleteNum == 0)
				{
					deleteArpIndex = index;
				}
				else
				{
					deleteArpIndex += FIRST_DELIMITER + index;
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one ARP at least!");
			}
			else
			{
				alert("请至少选中一个ARP！");
			}
			return;
		}
		data += deleteArpIndex;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The checked ARP are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("选中ARP删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function deleteAll()
{
	var confirmPrompt;
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(rowNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("The ARP number is 0!");
		}
		else if(language == CHINESE)
		{
			alert("ARP个数是0！");
		}
		return;
	}
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all the ARP?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除全部ARP吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + GBE_ARP_CONFIG + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=0xffff";
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("ARP are all deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("所有ARP删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}