﻿/*************************************************
Copyright (C), 2000-2010, Sumavision Tech. Co., Ltd.
File name: 		common.js  
Author:			xiayuxiao wangyuqi zhaoliying
Version:		v1.0
Date: 			2013/01/25
Description:  	web页面公用js代码模块
History: 
1. Date: Author: Modification:
2. ...
*************************************************/
var slotNo;
var portNo;
var startRefreshTime;

var MODAL_HEIGHT = 36;
var MODAL_WIDTH = 148;
//分隔符
var FIRST_DELIMITER = "<*1*>";
var SECOND_DELIMITER = "<*2*>";
var THIRD_DELIMITER = "<*3*>";

//cmd value
var GET = 1;
var SET = 2;
var ADD = 3;
var DELETE = 4;

var OFF = 0;  //Off
var ON = 1;   //On

//language value
var ENGLISH = 0;  //English
var CHINESE = 1;  //Chinese

var pageLanguage = ["_en.asp", "_cn.asp"];

var refreshFlag = false;  //刷新后页面弹出提示的标识符，false为初始状态，刷新成功则设为true，页面提示后重新恢复初始值false
var applyFlag = false;  //设置后页面弹出提示的标识符，false为初始状态，设置成功则设为true，页面提示后重新恢复初始值false

//页面设置或者刷新时的提示常量，区分刷新还是设置，提示的位置
var REFRESH = 1;  //Refresh
var APPLY = 2;  //Apply
var TOP = 1;  //Top
var BOTTOM = 2;  //Bottom

//页面自适应的4种情况
var BUTTON_TOP_NO_MENU = 1;
var BUTTON_TOP_MENU = 2;
var BUTTON_BOTTOM_NO_MENU = 3;
var BUTTON_BOTTOM_MENU = 4;

//高度自适应时页面按钮的位置横向是否需要微调保持始终对准中线位置
var NO_BUTTON_CHANGE = 0;
var BUTTON_CHANGE = 1;

var MAIN_GBE_CARD = 6;

//页面设置和刷新按钮点击后弹出提示的simplemodal插件的option设置,在页面上方，适合表格内的按钮
var PromptOptionTop = {
	close: false,
	modal: false,
	//opacity:60,
	overlayId: "prompt-overlay",
	containerId: "prompt-container",
	position: ["0%","82%"],
	autoPosition: true,
	containerCss: {
		height: "30px",
		width: "140px",
		border: "1px solid #ccc"
	}
};
//页面设置和刷新按钮点击后弹出提示的simplemodal插件的option设置,在页面底部，适合底部有按钮的页面
var PromptOptionBottom = {
	close: false,
	modal: false,
	//opacity:60,
	overlayId: "prompt-overlay",
	containerId: "prompt-container",
	position: ["87%","41%"],
	autoPosition: true,
	containerCss: {
		height: "30px",
		width: "140px",
		border: "1px solid #ccc"
	}
};

var RETURN_OK = 0;

var DISPLAY_STRING = "********************************";  //授权码的默认显示

//按钮类型（按尺寸区分）
var SMALL = 0;

//设备的备份使能的的值，1是备份使能，0是备份不使能
var DEVICE_BACKUP = 1;
var DEVICE_NO_BACKUP = 0;

//用户类别权限定义，1是系统管理员，2是超级用户，3是普通用户
var ADMINISTRATOR = 1;
var POWER_USER = 2;
var USER = 3;

/*************************************************
Function: 		AddRow
Description: 	用于动态添加一行
Input: 			tableId: Table ID;
				trId: Tr ID;
				trClass: Tr Class;
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function AddRow(tableId, trId, trClass)
{ 
	var objArray;
	var obj;
	var objLength;
	var idLength;
	var id;
	var newId;
	var vTb = $("#" + tableId); 
	var vNum = $("#" + tableId + " tr").filter("." + trClass).length + 1;
	var vTr = $("#" + trId + "0");
	var vTrClone = vTr.clone(true);
	vTrClone.attr("id", trId + vNum);
	vTrClone.appendTo(vTb);
	$("#" + tableId + " #" + trId + vNum + " td").each(function(){
		objArray = $(this).children();
		objLength = objArray.length;
		if(objLength != 0)
		{
			for(var i = 0; i < objLength; i++)
			{
				obj = $(objArray[i]);
				id = obj.attr("id");
				idLength = id.length;
				newId = id.slice(0, (length - 1)) + vNum;
				obj.attr("id", newId);
			}
		}
	}); 
} 

/*************************************************
Function: 		DelRow
Description: 	用于动态删除一行
Input: 			tableId: Table ID;
				trId: Tr ID;
				trClass: Tr Class;
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function DelRow(tableId, trId, trClass)
{
	var vNum = $("#" + tableId + " tr").filter("." + trClass).length;
	var vTr = $("#" + tableId + " #" + trId + vNum);
	vTr.remove();
}

/*************************************************
Function: 		DrawTableRow
Description: 	用于动态画表格
Input: 			tableId: Table ID;
				trId: Tr ID;
				trClass: Tr Class;
				rowNum: 要画的表格总行数
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function DrawTableRow(tableId, trId, trClass, rowNum)
{
	var curRowNum;
	
	curRowNum = $("#" + tableId + " tr").filter("." + trClass).length;
	if(rowNum == curRowNum)
	{
		return;
	}
	else if(rowNum > curRowNum)
	{
		for(var i = 0; i < (rowNum - curRowNum); i++)
		{
			AddRow(tableId, trId, trClass);
		}
	}
	else
	{
		for(var i = 0; i < (curRowNum - rowNum); i++)
		{
			DelRow(tableId, trId, trClass);
		}
	}
}

/*************************************************
Function: 		DrawTableTwoRow
Description: 	用于动态画表格，表格是两行为一条信息
Input: 			tableId: Table ID;
				trId1: Tr ID 1;
				trClass1: Tr Class 1;
				trId2: Tr ID 2;
				trClass2: Tr Class 2;
				rowNum: 要画的表格总行数
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function DrawTableTwoRow(tableId, trId1, trClass1, trId2, trClass2, rowNum)
{
	var curRowNum;
	
	curRowNum = $("#" + tableId + " tr").filter("." + trClass1).length;
	if(rowNum == curRowNum)
	{
		return;
	}
	else if(rowNum > curRowNum)
	{
		for(var i = 0; i < (rowNum - curRowNum); i++)
		{
			AddRow(tableId, trId1, trClass1);
			AddRow(tableId, trId2, trClass2);
		}
	}
	else
	{
		for(var i = 0; i < (curRowNum - rowNum); i++)
		{
			DelRow(tableId, trId1, trClass1);
			DelRow(tableId, trId2, trClass2);
		}
	}
}

function DelayAndCheck(position)
{
    var timeObj;
	var endTime;
	
	timeObj = new Date();
	endTime = timeObj.getTime();
	
	if((endTime - startRefreshTime) < 5000)
	{
		if(refreshFlag == true)
		{
			GeneratePrompt(refreshFlag, position, REFRESH, language);
			return;
		}
	}
	else
	{
		GeneratePrompt(refreshFlag, position, REFRESH, language);
		return;
	}
	
	setTimeout(function(){DelayAndCheck(position);}, 50);
}

function PageRefresh(position)
{ 
	var timeObj;
    refreshFlag = false;
    funcUpdateDisplay(); 
    timeObj = new Date();
	startRefreshTime = timeObj.getTime();
    DelayAndCheck(position);
}

/*************************************************
Function: 		GeneratePrompt
Description: 	用于页面点击设置和刷新后弹出提示框
Input: 			result: Apply/Refresh result, ture-success; false-failure;
				position: position type, 1-Top; 2-Bottom;
				type: action type, 1-Refresh; 2-Apply;
				language: 1-English; 2-Chinese
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function GeneratePrompt(result, position, type, language)
{
	var obj = $(".div_table_button_area");
	if(result == true)
	{
		$("#promptSuccess").css("display", "");
		$("#promptError").css("display", "none");
		if(type == REFRESH)
		{
			if(language == ENGLISH)
			{
				$("#promptText").html("Refresh OK");
			}
			else if(language == CHINESE)
			{
				$("#promptText").html("刷新成功");
			}
		}
		else if(type== APPLY)
		{
			if(language == ENGLISH)
			{
				$("#promptText").html("Apply OK");
			}
			else if(language == CHINESE)
			{
				$("#promptText").html("设置成功");
			}
		}
	}
	else
	{
		$("#promptSuccess").css("display", "none");
		$("#promptError").css("display", "");
		if(type == REFRESH)
		{
			if(language == ENGLISH)
			{
				$("#promptText").html("Refresh Error");
			}
			else if(language == CHINESE)
			{
				$("#promptText").html("刷新失败");
			}
		}
		else if(type == APPLY)
		{
			if(language == ENGLISH)
			{
				$("#promptText").html("Apply Error");
			}
			else if(language == CHINESE)
			{
				$("#promptText").html("设置失败");
			}
		}
	}
	if(position == TOP)
	{
		PromptOptionTop.position[0] = obj.offset().top - MODAL_HEIGHT + "px";
		PromptOptionTop.position[1] = obj.offset().left + obj.width() - MODAL_WIDTH + "px";
		$("#promptInfo").modal(PromptOptionTop);
	}
	else if(position == BOTTOM)
	{
		$("#promptInfo").modal(PromptOptionBottom);
	}
	setTimeout("$.modal.close();", 1000);  //1s后提示自动消失
}

/*************************************************
Function: 		AjaxStrDeal
Description: 	用于ajax交互获取的字符串处理，去掉包裹在有效信息外的<html></html>字符串
Input: 			str: 待处理字符串
Output: 		无
Return: 		newStr: 处理后返回有效字符串
Others: 		无
*************************************************/
function AjaxStrDeal(str)
{
	var index;
	var end;
	var newStr;
	
	index = str.indexOf("</html>");
	end = str.length - index;
	newStr = str.slice(7, - end);
	
	return newStr;
}

/*************************************************
Function: 		GetIndexFromId
Description: 	用于获取参数是第几行，获取id最后一个字符
Input: 			obj: 待处理参数,jquery对象
				num: 行id去掉index部分剩下字符串的长度
Output: 		无
Return: 		index: 返回第几行，整数。从1开始计数
Others: 		使用这个函数行的id必须固定为(rowId)1，(rowId)2...id的结尾是index
*************************************************/
function GetIndexFromId(obj, num)
{
	var tr = obj.parent().parent();
	var trId = tr.attr("id");
	index = parseInt(trId.slice(num));
	
	return index;
}
/*************************************************
Function: 		GetMainframeHeight
Description: 	用于页面的iframe高度自适应
Input: 			type:page type, 1-无横向菜单的按钮在右上架构页面;2-有横向菜单的按钮在右上架构页面;3-无横向菜单的按钮固定在下面架构页面;3-有横向菜单的按钮固定在下面架构页面
				flag: button change flas, 0-no change; 1-change
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function GetMainContentHeight(type, flag)
{
	var height;
	
	switch(type)
	{
		case BUTTON_TOP_NO_MENU:
			height = 0;
			break;
		case BUTTON_TOP_MENU:
			height = 28;
			break;
		case BUTTON_BOTTOM_NO_MENU:
			height = 30;
			break;
		case BUTTON_BOTTOM_MENU:
			height = 58;
			break;
		default:
			break;
	}
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.iframeHeight - height) + "px");
	});
	if(flag == BUTTON_CHANGE)
	{
		ChangeButtonLocation();
	}
}

/*************************************************
Function: 		ChangeButtonLocation
Description: 	列表架构页面使用，用于使列表的中线始终正对着按钮中间
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function ChangeButtonLocation()
{
	$("#buttonArea").css("width", function(index, value)
		{
			return ($("#hiddenDiv").css("width"));
		});
}

/*************************************************
Function: 		PageLoadStatus
Description: 	用于页面加载时提示页面加载状态
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function PageLoadStatus(flag)
{
	if(flag == true)
	{
		document.body.style.cursor = "wait";
		window.status = "Retrieving data, please wait...";
	}
	else
	{
		document.body.style.cursor = "auto";
		window.status = "Done";
	}
}

/*************************************************
Function: 		GetArgs
Description: 	从urld地址获取参数
Input: 			无
Output:			无
Return: 		参数值,args[name]=value
Others: 		无
*************************************************/
function GetArgs() 
{
    var args = new Object();
    var query = location.search.substring(1);  //Get query string
    var pairs = query.split("&");  //Break at & ampersand
    for(var i = 0; i < pairs.length; i++) 
	{
        var pos = pairs[i].indexOf('=');  //Look for "name=value"
        if(pos == -1) 
		{
			continue;  //If not found, skip
		}
        var argname = pairs[i].substring(0, pos);  //Extract the name
        var value = pairs[i].substring(pos + 1);  //Extract the value
        value = decodeURIComponent(value);  //Decode it, if needed
        args[argname] = value;  //Store as a property
    }
    return args;  //Return the object
}

/*************************************************
Function: 		ResetColor
Description: 	用于恢复页面中编辑项（包括输入框和下拉框）的颜色
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function ResetColor()
{
	$("select,input[type=text]:not(readonly)").css("backgroundColor", "white");
}

/*************************************************
Function: 		inButtonClassChange
Description: 	用于控制页面中各种按钮的鼠标掠过后的样式变化
Input: 			curClass: button current class, include 4 types according width
				id: button id
Output:			无
Return: 		无
Others: 		无
*************************************************/
function inButtonClassChange(curClass, id)
{
	switch(curClass)
	{
		case "input_small_normal":
			$("#" + id).attr("class", "input_small_mouseover");
			break;
			
		case "input_normal":
			$("#" + id).attr("class", "input_mouseover");
			break;
			
		case "input_middle1_normal":
			$("#" + id).attr("class", "input_middle1_mouseover");
			break;
			
		case "input_middle2_normal":
			$("#" + id).attr("class", "input_middle2_mouseover");
			break;
			
		case "input_big_normal":
			$("#" + id).attr("class", "input_big_mouseover");
			break;
			
		default:
			break;
	}
}

function outButtonClassChange(curClass, id)
{
	switch(curClass)
	{
		case "input_small_mouseover":
			$("#" + id).attr("class", "input_small_normal");
			break;
			
		case "input_mouseover":
			$("#" + id).attr("class", "input_normal");
			break;
			
		case "input_middle1_mouseover":
			$("#" + id).attr("class", "input_middle1_normal");
			break;
			
		case "input_middle2_mouseover":
			$("#" + id).attr("class", "input_middle2_normal");
			break;
			
		case "input_big_mouseover":
			$("#" + id).attr("class", "input_big_normal");
			break;
			
		default:
			break;
	}
}

/*************************************************
Function: 		ChangeMenuClass
Description: 	用于二级菜单鼠标掠过效果
Input: 			curClass: button current class, include 4 types according width
				id: button id
Output:			无
Return: 		无
Others: 		无
*************************************************/
function ChangeMenuClass(curClass, id)
{
	switch(curClass)
	{
		case "table_header_normal":
			$("#" + id).attr("class", "table_head_mouseover");
			break;
		case "table_head_mouseover":
			$("#" + id).attr("class", "table_header_normal");
			break;
		default:
			break;
	}
}

/*************************************************
Function: 		AddTabMouseAction
Description: 	添加二级菜单鼠标掠过效果
Input:			id: button id
Output:			无
Return: 		无
Others: 		无
*************************************************/
function AddTabMouseAction(id)
{
	$("#" + id).bind("mouseover mouseout", function()
	{
		ChangeMenuClass($(this).attr("class"), id);
	});
}
 
/*************************************************
Function: 		DisableButton
Description: 	用于使按钮置灰处于不可用状态
Input: 			id: button id;size:button size,0:SMALL
Output:			无
Return: 		无
Others: 		无
*************************************************/
function DisableButton(id, size)
{
	var $btn = $("#" + id);
	
	if(size == SMALL)
	{
		$btn.attr("class", "input_small_normal");
	}
	if(id == "applyBtn")
	{
		$btn.attr("class", "input_normal");
	}
	$btn.prop("disabled", true);
	$btn.css("cursor", "auto");	
	$btn.css("color", "#666");	
}

/*************************************************
Function: 		EnableButton
Description: 	用于使按钮变亮处于可用状态
Input: 			id: button id
Output:			无
Return: 		无
Others: 		无
*************************************************/
function EnableButton(id)
{
	var $btn = $("#" + id);
	
	$btn.prop("disabled", false);
	$btn.css("cursor", "pointer");
	$btn.css("color", "#1584C4");
}

/*************************************************
Function: 		无名
Description: 	页面加载时调用的函数
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
$(function()
{
	//页面所有的只读input控件边框设为0
	$("input[readonly=readonly]").css("border", "0");
	
	//页面可编辑的输入框（非只读）和textarea绑定keyup事件：背景色变黄，Apply按钮变亮
	if(top.groupAccess != USER)
	{
		$("input[type=text][readonly!=readonly], textarea").live("keyup", function()
		{
			this.style.backgroundColor = "#feffe0";
			EnableButton("applyBtn");
		});
		//页面下拉菜单绑定change事件：背景色变黄，Apply按钮变亮
		$("select").live("change", function()
		{
			this.style.backgroundColor = "#feffe0";
			EnableButton("applyBtn");
		});
	}	
	//使按钮聚焦时没有虚线框
	$("input[type='button']").bind("focus", function()
	{
		if(this.blur)
		{
			this.blur();
		}
	});
	
	//统一添加鼠标掠过 滑出按钮时的效果
	$("input[type='button']").bind("mouseover", function()
	{
		inButtonClassChange($(this).attr("class"), $(this).attr("id"));
	});
	$("input[type='button']").bind("mouseout", function()
	{
		outButtonClassChange($(this).attr("class"), $(this).attr("id"));
	});
});

/*************************************************
Function: 		CreateHiddenFormElement
Description: 	为form创建隐藏的input控件，用于页面中有多个form
Input:			formId: form id
				name: input name
				value: input value
Output:			无
Return: 		无
Others: 		无
*************************************************/
function CreateHiddenFormElement(formId, name, value)
{
	var tempform = document.getElementById(formId);
	var newInput = document.createElement("input");
	newInput.type = "hidden";	
	newInput.name = name;		
	newInput.value = value;			
	tempform.appendChild(newInput);	
}

function ValidateAuthCode(obj, language)
{
	var patten = /^([A-F0-9]){32}$/;
	var licence;
	
	licence = obj.val();
	if((licence != DISPLAY_STRING) && (!patten.test(licence)))
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid licence!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的授权码！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	
	return true;
}

function ValidateName(obj, language)
{
	var charName;
	var nameValue = obj.val();
	var length = nameValue.length;
	
	for(var i = 0; i < length; i++)
	{
		charName = nameValue.charAt(i);
		if((charName == '"') || (charName == "%") || (charName == "\\") || (charName == "+") || (charName == "&"))
		{
			if(language == ENGLISH)
			{
				alert("Can't input special symbols!");
			}
			else
			{
				alert("不能输入特殊符号！");
			}
			setTimeout(function () {obj.focus()}, 0);
			setTimeout(function () {obj.select()}, 0);
			return false;
		}
	}
	
	return true;
}
/*************************************************
Function:  		ValidateParam
Description:  	非IP类参数校验，弹出校验结果，输入无效则聚焦
Input:  		obj: current param jquery object; 
				type: param type; 
				minValue: min value; 
				maxValue: max value; 
				str1: English param name; 
				str2: Chinese param name;
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		minValue and maxValue both 0, value is no range
				when type is "LENGTH", minValue and maxValue are the length value
*************************************************/
function ValidateParam(obj, type, minValue, maxValue, str1, str2, language)
{
	var patten;
	var strVal = obj.val();
	var numVal;
	var minValDisplay;
	var maxValDisplay;
	switch(type) 
	{
		case "INT_DEC":  //十进制整数
			patten = /^-?\d+$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a decimal integer!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是十进制整数！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "INT_DEC_HEX":  //十进制或十六进制（以0x或0X开头），非负整数
			patten = /(^\d+$)|(^0[xX]([A-Fa-f0-9])+$)/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a non-negative integer(decimal or hexadecimal which starts with 0x or 0X)!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是非负整数（十进制或者十六进制，其中十六进制数以0x或0X起始）！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "INT_HEX":  //十六进制非负整数
			patten = /^([A-Fa-f0-9])+$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a hexadecimal non-negative integer!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是十六进制非负整数！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "INT_HEX_NULL":  //十六进制非负整数，可以为空
			patten = /^([A-Fa-f0-9])*$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a hexadecimal non-negative integer!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是十六进制非负整数！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "LENGTH":  //只对长度有要求
			var strLength = strVal.replace(/[^\x00-\xff]/g,'***').length;
			if(minValue == maxValue)  //Length is fixed
			{
				if(strLength != minValue)
				{
					if(language == ENGLISH)
					{
						alert("The length of " + str1 + " should be " + minValue + "!");
					}
					else if(language == CHINESE)
					{
						alert(str2 + "长度应该为 " + minValue + "！");
					}
					setTimeout(function () {obj.focus()}, 0);
					setTimeout(function () {obj.select()}, 0);
					return false;
				}
			}
			else
			{
				if((strLength < minValue) || (strLength > maxValue))  //长度范围
				{
					if(language == ENGLISH)
					{
						alert("The length of " + str1 + " should be between " + minValue + " and " + maxValue + "!");
					}
					else if(language == CHINESE)
					{
						alert(str2 + "长度应该在 " + minValue + "和" + maxValue + "之间！");
					}			
					setTimeout(function () {obj.focus()}, 0);
					setTimeout(function () {obj.select()}, 0);
					return false;
				}
			} 
			break;
			
		case "FLOATING":  //非负浮点数
			var patten  = /^\d+(\.\d+)?$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " Please input a valid number!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "请输入合法的数字！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false;
			}
			break;
		default:
			break;
	}
	if(type != "LENGTH")  //数值范围，非长度范围
	{
		if((type == "INT_DEC") || (type == "INT_DEC_HEX"))  //可输入十进制的整数
		{
			var ch = strVal.slice(0, 2);
			if((ch == "0x") || (ch == "0X"))  //十六进制
			{
				numVal = parseInt(strVal, 16);
			}
			else  //十进制
			{
				numVal = parseInt(strVal, 10);
			}
		}
		else if((type == "INT_HEX") || (type == "INT_HEX_NULL"))  //纯十六进制整数
		{
			if(strVal == "")
			{
				return true;
			}
			numVal = parseInt(strVal, 16);
		}
		else if(type == "FLOATING") //浮点数
		{
			numVal = parseFloat(strVal);
		}
		if((minValue < maxValue) || ((minValue > 0) && (minValue = maxValue))) //有数值范围,主千兆卡端口添加告警可能范围是[1,1]，输入0,0表示参数没有取值范围
		{
			if((numVal < minValue) || (numVal > maxValue))
			{
				if(type == "INT_DEC_HEX")
				{
					minValDisplay = minValue + "(0x" + minValue.toString(16) + ")";
					maxValDisplay = maxValue + "(0x" + maxValue.toString(16) + ")";
				}
				else if((type == "INT_HEX") || (type == "INT_HEX_NULL"))
				{
					minValDisplay = "0x" + minValue;
					maxValDisplay = "0x" + maxValue;
				}
				else
				{
					minValDisplay = minValue;
					maxValDisplay = maxValue;
				}
				if(language == ENGLISH)
				{
					alert(str1 + " should be between " + minValDisplay + " and " + maxValDisplay + "!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该在" + minValDisplay + "和" + maxValDisplay + "之间！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false;
			}
		}
	}
	return true; 
}

function unifyDataFormat(obj)
{
	var paramValue;
	var paramString = obj.val();
	var ch;
	ch = paramString.slice(0, 2);
	if((ch == "0x") || (ch == "0X"))  //十六进制
	{
		paramValue = parseInt(paramString, 16);
	}
	else  //十进制
	{
		paramValue = parseInt(paramString, 10);
	}
	return paramValue;
}

/*************************************************
Function:  		ValidateIP
Description:  	校验IP参数，弹出校验结果，输入无效则聚焦
Input:  		obj: current IP param jquery object;
				type: param type; 
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateIP(obj, type, str1, str2, language)
{
	switch(type) 
	{
		case "UNICAST_IP_ADDR":  //first field value [1, 223] exclude 127, not including 223.255.255.255
			if(ValidateUnicastIP(obj, str1, str2, language) == false)
			{
				return false;
			}
			break;
		case "IP_ADDR":  //first field value [1, 255] exclude 127
			if(ValidateUniAndMultiIP(obj, str1, str2, language) == false)
			{
				return false;
			}
			break;
		case "SOURCE_IP":
			if(ValidateSourceIP(obj, str1, str2, language) == false)
			{
				return false;
			}
			break;
		case "SUBNET_MASK":  //子网掩码，固定的格式
			if(ValidateSubnetMask(obj, str1, str2, language) == false)
			{
				return false;
			}
			break;
		case "GATEWAY":  //all fields value [0, 255]
			if(ValidateGateway(obj, str1, str2, language) == false)
			{
				return false;
			}
			break;
		default:
			break;
	}
	return true; 
}

/*************************************************
Function:  		ValidateUnicastIP
Description:  	校验单播IP参数，弹出校验结果，输入无效则聚焦
				单播IP类的要求：
				(1) IP格式检验正确
				(2) 第一个字节必须在[1,223]内，不包含223.255.255.255
				(3) 不能为127.x.x.x
Input:  		obj: current unicast IP param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateUnicastIP(obj, str1, str2, language)
{
	var ipAddr = obj.val();
	var num = IP2Num(ipAddr);
	var ipAddrFields = ipAddr.split(".");
	var length = ipAddrFields.length;
	var firstFieldValue = parseInt(ipAddrFields[0]);
	
	if(ValidateIPFormat(ipAddr) == false)
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	
	if((firstFieldValue < 1) || (firstFieldValue > 223) || (firstFieldValue == 127))
	{
		if(language == ENGLISH)
		{
			alert(str1 + " should be a unicast address!(the first field value range should be [1, 223], not including 127)");
		}
		else if(language == CHINESE)
		{
			alert(str2 + "应该是单播地址！（单播地址第一个值的范围是[1, 223], 不包含127）");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
	
	if(num == 3758096383)
	{
		if(language == ENGLISH)
		{
			alert("223.255.255.255(reserved) is not a valid" + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("223.255.255.255（保留）不是合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
	return true;
}

/*************************************************
Function:  		ValidateUniAndMultiIP
Description:  	校验单播或组播IP参数，弹出校验结果，输入无效则聚焦
				单播或组播IP类的要求：
				(1) IP格式检验正确
				(2) 第一个字节不能为0
				(3) 不能为127.x.x.x
Input:  		obj: current unicast or multicast IP param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateUniAndMultiIP(obj, str1, str2, language)
{
	var ipAddr = obj.val();
	var ipAddrFields = ipAddr.split(".");
	var length = ipAddrFields.length;
	var firstFieldValue = parseInt(ipAddrFields[0]);
	
	if(ValidateIPFormat(ipAddr) == false)
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	
	if((firstFieldValue == 0) || (firstFieldValue == 127))
	{
		if(language == ENGLISH)
		{
			alert("The first field value range of" + str1 + "should be [1, 255], not including 127!");
		}
		else if(language == CHINESE)
		{
			alert(str2 + "第一个值的范围是[1, 255], 不包含127！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
	return true;
}

/*************************************************
Function:  		ValidateSourceIP
Description:  	校验源IP参数，弹出校验结果，输入无效则聚焦
				源IP类的要求：
				(1) IP格式检验正确
				(2) 单播，可以为0.0.0.0
				(3) 不能为127.x.x.x
Input:  		obj: current unicast or multicast IP param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateSourceIP(obj, str1, str2, language)
{
	var ipAddr = obj.val();
	var num = IP2Num(ipAddr);
	var ipAddrFields = ipAddr.split(".");
	var length = ipAddrFields.length;
	var firstFieldValue = parseInt(ipAddrFields[0]);
	
	if(ValidateIPFormat(ipAddr) == false)
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	
	if(((firstFieldValue < 1) && (num != 0)) || (firstFieldValue > 223) || (firstFieldValue == 127))
	{
		if(language == ENGLISH)
		{
			alert(str1 + " should be a unicast address!(the first field value range should be [1, 223], not including 127, including 0.0.0.0)");
		}
		else if(language == CHINESE)
		{
			alert(str2 + "应该是单播地址！（单播地址第一个值的范围是[1, 223], 不包含127,可以为0.0.0.0）");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
	
	if(num == 3758096383)
	{
		if(language == ENGLISH)
		{
			alert("223.255.255.255(reserved) is not a valid" + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("223.255.255.255（保留）不是合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
	return true;
}

/*************************************************
Function:  		ValidateSubnetMask
Description:  	校验子网掩码，弹出校验结果，输入无效则聚焦
				子网掩码类的要求：
				(1) IP格式检验正确
				(2) 子网掩码不能为全0和全1，其中的1必须是连续的且位于最高若干位
Input:  		obj: current subnet mask param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateSubnetMask(obj, str1, str2, language)
{
    var flag = -1;
	var mask = obj.val();
    var num = IP2Num(mask);
    var str = num.toString(2);
	
	if(ValidateIPFormat(mask) == false)
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	if(num == 0)
	{
		if(language == ENGLISH)
		{
			alert("0.0.0.0 is not a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("0.0.0.0不是合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
	if(num == 4294967295)
	{
		if(language == ENGLISH)
		{
			alert("255.255.255.255 is not a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("255.255.255.255不是合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false; 
	}
    for(var i = 0; i < str.length; i++) 
    {
        if(str.charAt(i) == "0")
		{
            flag = i;
		}
        if((str.charAt(i) == "1") && (flag > -1))
		{
			if(language == ENGLISH)
			{
				alert(str1 + " format is not correct!");
			}
			else if(language == CHINESE)
			{
				alert(str2 + "格式不正确！");
			}
			setTimeout(function () {obj.focus()}, 0);
			setTimeout(function () {obj.select()}, 0);
			return false;
		}
    }
    return true;
}

/*************************************************
Function:  		ValidateSubnetMaskRelation
Description:  	校验子网掩码和IP地址关系的函数，弹出校验结果，输入无效则聚焦
				子网掩码和IP地址关系的要求：
				(1) 设IP地址和子网掩码都转换为网络字节序的整数之后为ip，mask，则需满足：(ip&(~mask)!=0)&&(ip&(~mask)!=(~mask))
Input:  		ip: IP address
				maskObj: current subnet mask param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateSubnetMaskRelation(ip, maskObj, str1, str2, language)
{
	var mask = maskObj.val();
	var ipNum;
	var maskNum;
	var networkByte;
	var antiMask;
	
	ipNum = IP2Num(ip);
	maskNum = IP2Num(mask);
	networkByte = ipNum & (~maskNum);
	antiMask = ~maskNum;
	if((networkByte == 0) || (networkByte == antiMask))
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + ", Subnet Mask and IP Address do not match!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "，子网掩码与IP地址不相符！");
		}
		setTimeout(function(){maskObj.focus()}, 0);
		setTimeout(function(){maskObj.select()}, 0);
		return false;
	}
	return true;
}

/*************************************************
Function:  		ValidateGateway
Description:  	校验网关，弹出校验结果，输入无效则聚焦
				网关类的要求：
				(1) IP格式检验正确
Input:  		obj: current gateway param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateGateway(obj, str1, str2, language)
{
	var gateway = obj.val();
	
	if(ValidateIPFormat(gateway) == false)
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + "!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	return true;
}

/*************************************************
Function:  		ValidateGatewayRelation
Description:  	校验网关和IP地址关系的函数，弹出校验结果，输入无效则聚焦
				网关和IP地址关系的要求：
				(1) 子网掩码、网关和IP必须落在同一网段
Input:  		ip: IP address
				mask: subnet mask
				gatewayObj: current gateway param jquery object;
				str1: English param name; 
				str2: Chinese param name; 
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateGatewayRelation(ip, mask, gatewayObj, str1, str2, language)
{
    var gateway = gatewayObj.val();
	var ipNum;
	var maskNum;
	var gatewayNum;
	var ipMask;
	var gatewayMask;
	
    ipNum = IP2Num(ip);
    maskNum = IP2Num(mask);
    gatewayNum = IP2Num(gateway);
    ipMask = (ipNum & maskNum)>>>0;
    gatewayMask = (gatewayNum & maskNum)>>>0;
    if(ipMask != gatewayMask)
	{
		if(language == ENGLISH)
		{
			alert("Please input a valid " + str1 + ", Gateway and IP Address do not fall in the same network!");
		}
		else if(language == CHINESE)
		{
			alert("请输入合法的" + str2 + "，网关和IP地址没有落到同一网段！");
		}
		setTimeout(function(){gatewayObj.focus()}, 0);
		setTimeout(function(){gatewayObj.select()}, 0);
		return false;
	}
    return true;
}

/*************************************************
Function:  		ValidateIPFormat
Description:  	校验IP地址格式的函数，弹出校验结果，输入无效则聚焦
				IP地址格式的要求：
				(1) 4个数字用“.”连接起来
				(2) 每个数字是范围为[0, 255]的整数
Input:  		ipAddr: IP address
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateIPFormat(ipAddr)
{
	var ipAddrFields = ipAddr.split(".");
	var length = ipAddrFields.length;
	var fieldValue;
	
	// make sure there are 4 octets
	if(length != 4)
	{
		return false;
	}
	for(var i = 0; i < length; i++)
	{
		if(ValidateNumber(ipAddrFields[i]) == false)
		{
			return false;
		}
		fieldValue = parseInt(ipAddrFields[i]);
		if((fieldValue < 0) || (fieldValue > 255))
		{
			return false;
		}
	}
	return true;
}

/*************************************************
Function:  		ValidateNumber
Description:  	校验非负整数的函数，弹出校验结果，输入无效则聚焦
Input:  		input: 需要校验的值
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		无
*************************************************/
function ValidateNumber(input)
{
	var len = input.length;

	if(len == 0)
	{
		return false;
	}
	for(var i = 0; i < len; i++)
	{
		if(isNaN(parseInt(input.charAt(i))))
		{
			return false;
		}
	}
	return true;
}

/*************************************************
Function:  		IPCompare
Description:  	校验两个IP地址是否相等
Input:  		ipString1,ipString2: 需要校验的值
Output:			无
Return:  		如果相等 return ture; 否则 return false
Others: 		无
*************************************************/
function IPCompare(ipString1, ipString2)
{
	var ipArray1 = ipString1.split(".");
	var ipArray2 = ipString2.split(".");
	if((parseInt(ipArray1[0],10) == parseInt(ipArray2[0],10)) && (parseInt(ipArray1[1],10) == parseInt(ipArray2[1],10)) && (parseInt(ipArray1[2],10) == parseInt(ipArray2[2],10)) && (parseInt(ipArray1[3],10) == parseInt(ipArray2[3],10)))
	{
		return true;
	}
	else
	{
		return false;
	}
}
/*************************************************
Function:  		IP2Num
Description:  	IP地址转换成无符号整数的函数，弹出校验结果，输入无效则聚焦
Input:  		ip: IP address
Output:			无
Return:  		number
Others: 		无
*************************************************/
function IP2Num(ip) 
{
    var num = 0;
    ip = ip.split(".");
    num = Number(ip[0]) * 256 * 256 * 256 + Number(ip[1]) * 256 * 256 + Number(ip[2]) * 256 + Number(ip[3]);
    num = num >>> 0;
    return num;
}

/*************************************************
Function:  		Num2IP
Description:  	无符号整数转换成IP地址的函数，弹出校验结果，输入无效则聚焦
Input:  		num: number
Output:			无
Return:  		IP address
Others: 		无
*************************************************/
function Num2IP(num) 
{
    var str;
    var ip = new Array();
    ip[0] = (num >>> 24) >>> 0;
    ip[1] = ((num << 8) >>> 24) >>> 0;
    ip[2] = (num << 16) >>> 24;
    ip[3] = (num << 24) >>> 24;
    str = String(ip[0]) + "." + String(ip[1]) + "." + String(ip[2]) + "." + String(ip[3]);
    return str;
}

/*************************************************
Function: 		GetHTTPObject
Description: 	创建用于ajax传输的交互对象
Input: 			无
Output: 		无
Return: 		返回创建的对象
Others: 		无
*************************************************/
function GetHTTPObject()
{
	var xmlHttp = false;
	try
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch(e)
	{
		try
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch(e2)
		{
			xmlHttp = false;
		}
	}
	if((!xmlHttp) && (typeof xmlHttp != "undefined"))
	{
		try
		{
			xmlHttp = new XMLHttpRequest();
		}
		catch(e)
		{
			xmlHttp = false;
		}
	}

	return xmlHttp;
}

/*************************************************
Function: 		ExecuteScript
Description: 	ajax加载页面的时候，加载页面的js不能执行，这个函数用于执行ajax加载页面的js代码
Input: 			data:ajax返回的responseText
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function ExecuteScript(data)
{
	var regDetectJs = /<script(.|\n)*?>(.|\n|\r\n)*?<\/script>/ig;
	var jsContained = data.match(regDetectJs);
	// 第二步：如果包含js，则一段一段的取出js再加载执行
	if(jsContained)
	{
		// 分段取出js正则
		var regGetJS = /<script(.|\n)*?>((.|\n|\r\n)*)?<\/script>/im;
		// 按顺序分段执行js
		var jsNums = jsContained.length;
		for(var i = 0; i < jsNums; i++)
		{
		   var jsSection = jsContained[i].match(regGetJS);
		   if(jsSection[2])
		   {
				if(parent.window.execScript)
				{
					// 给IE的特殊待遇
					parent.window.execScript(jsSection[2]);
				}
				else
				{
					// 给其他大部分浏览器用的
					parent.window.eval(jsSection[2]);
				}
		   }
		}
	}
}