﻿var currentId;
var dvbIdArray = ["dvbServiceId", "dvbServiceName", "serviceProvider", "dvbPmtPid", "dvbPcrPid", "runStatus", "dvbServiceType", "customType", "encryptStatus"];
var atscIdArray = ["atscServiceId", "atscServiceName", "atscPmtPid", "atscPcrPid", "channelTsid", "majorChannel", "minorChannel", "modulMode", "atscServiceType", "serviceSource"];
var DVB_ROW_NUM = 9;
var ATSC_ROW_NUM = 10;
var identifyData;
var DVB = 0;
var CUSTOM = 17;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	currentId = args["ID"];
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var rowData;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CUSTOM_PROGRAM + "&cmd=" + GET + "&slotNo=" + slotNo + "&id=" + currentId + "&language=" + language + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				identifyData = parseInt(response, 10);
				if(identifyData == DVB)
				{
					if(language == ENGLISH)
					{
						$("#tabTitle").html("Custom Service(DVB)");
					}
					else
					{
						$("#tabTitle").html("自定义节目(DVB)");
					}
					$("#dvbTable").css("display", "");
					$("#atscTable").css("display", "none");			
				}
				else
				{
					if(language == ENGLISH)
					{
						$("#tabTitle").html("Custom Service(ATSC)");
					}
					else
					{
						$("#tabTitle").html("自定义节目(ATSC)");
					}					
					$("#dvbTable").css("display", "none");
					$("#atscTable").css("display", "");				
				}
			}
		}
	}
	xmlHttp.send(null);	
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CUSTOM_PROGRAM + "&cmd=" + SET + "&slotNo=" + slotNo + "&id=" + currentId + "&language=" + language  + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
				GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
				applyFlag = false;  //设置标识符恢复为false
				if(language == ENGLISH)
				{
					top.mainFrame.location.replace("mux_config_en.asp");
					parent.document.getElementById("menuBar").innerHTML = " > Multiplexing > Service Multiplexing";
				}
				else
				{
					top.mainFrame.location.replace("mux_config_cn.asp");
					parent.document.getElementById("menuBar").innerHTML = " > 复用 > 节目复用";
				}
			}
			else
			{
				alert(returnError[language][response]);
				GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
				applyFlag = false;  //设置标识符恢复为false
				funcUpdateDisplay();
			}
		}
	}
	xmlHttp.send(data);
}

function changeServiceType(obj)
{
	if(parseInt(obj.val(), 10) == CUSTOM)
	{			
		$("#customTypeTr").css("display", "");
	}
	else
	{
		$("#customTypeTr").css("display", "none");
	}
}

function generateData()
{
	var data;
	
	if(identifyData == DVB)
	{
		for(var i = 0; i < DVB_ROW_NUM; i++)
		{
			if(i == 0)
			{
				data = $("#" + dvbIdArray[i]).val();
			}
			else
			{
				data += FIRST_DELIMITER + $("#" + dvbIdArray[i]).val();
			}
		}
	}
	else
	{
		for(var i = 0; i < ATSC_ROW_NUM; i++)
		{
			if(i == 0)
			{
				data = $("#" + atscIdArray[i]).val();
			}
			else
			{
				data += FIRST_DELIMITER + $("#" + atscIdArray[i]).val();
			}
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	
	if(identifyData == DVB)
	{		
		returnFlag = ValidateParam($("#dvbServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}	
		returnFlag = ValidateParam($("#dvbServiceName"), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#dvbServiceName"), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#serviceProvider"), "LENGTH", 0, 31, "<Service Provider>", "<节目提供商>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#serviceProvider"), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#dvbPmtPid"), "INT_DEC_HEX", 32, 8190, "<PMT PID>", "<PMT PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#dvbPcrPid"), "INT_DEC_HEX", 32, 8190, "<PCR PID>", "<PCR PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(parseInt($("#dvbServiceType").val(), 10) == CUSTOM)
		{
			returnFlag = ValidateParam($("#customType"), "INT_DEC", 17, 255, "<Custom Type>", "<自定义类型>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
	}
	else
	{
		returnFlag = ValidateParam($("#atscServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}	
		returnFlag = ValidateParam($("#atscServiceName"), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#atscServiceName"), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#atscPmtPid"), "INT_DEC_HEX", 32, 8190, "<PMT PID>", "<PMT PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#atscPcrPid"), "INT_DEC_HEX", 32, 8190, "<PCR PID>", "<PCR PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#channelTsid"), "INT_DEC", 0, 65535, "<Channel TSID>", "<频道流ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#majorChannel"), "INT_DEC", 1, 99, "<Major Channel>", "<主频道号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#minorChannel"), "INT_DEC", 0, 999, "<Minor Channel>", "<子频道号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#serviceSource"), "INT_DEC", 1, 4095, "<Service Source>", "<节目源>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;	
}