﻿var TO_RIGHT = 1;
var TO_LEFT = 2;
var BUTTON_TAB_BLANK_HEIGHT = 69;

var MUX_CARD_REFRESH = 1;
var MUX_PORT_REFRESH = 2;
var MUX_PSI_PREVIEW = 3;
var MUX_PSI_INTERVAL = 4;
var MUX_PSI_EDIT = 5;
var MUX_CUSTOM = 6;
var MUX_AUTO_ADJUST = 7;
var MUX_PORT_DETAIL = 8;
var MUX_PROGRAM_BACKUP = 9;
var MUX_PID_MODIFY = 10;

var OPER_MUX_APPLY = 1;
var OPER_CARD_REFRESH = 2;
var OPER_PORT_REFRESH = 3;
var OPER_AUTO_ADJUST = 4;
var OPER_MODIFY_PID = 5;

var SEARCHING = 1;

var mainMenu = ["Multiplexing", "复用"];
var treeMenu = ["Service Multiplexing", "节目复用"];
var cardArray = ["Card", "卡"];
var gbeArray = ["GbE", "网口"];
var portArray = ["Port", "端口"];
var progArray = ["Service", "节目"];
var ONE_GBE_PORT_NUM = 256;
var GBE_ONE = 1;
var GBE_TWO = 2;

var curMenuId = null;

var inputArray;
var outputArray;
var inCardNum;
var outCardNum;

var outputNodes;

//定义存储复用参数的数组
var addInfo = new Array();
var delInfo = new Array();

var applyData;
var operation;

var selectNodeTop;
var selectNodeLeft;
var selectNodeWidth;
var curPortId;

//定义两个变量存储树信息
var zTree1, zTree2;
//设置配置参数 和 方法
var setting =
{
	editable: false,//参数设置为true便可使用拖拽功能
	edit_renameBtn:false,
	edit_removeBtn:false,
	dragCopy: true,//拖拽功能为复制然后在目的菜单添加
	dragMove: false,//拖拽功能为先删除然后在目的菜单添加
	data: {
		key: {
			children: "nodes"
		},
		simpleData: {
			enable : false,
			idKey : "id",
			pIdKey : "pId",
			rootPId : null
		}
	},
	view: {
		showLine: true,
		showTitle:false,
		selectedMulti: false
	},
	callback: {
		onRightClick: zTreeRightClick 
	}
};


window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	$(".mux_tree_content, .mux_button").css("height", function(index, value)
	{
		return ((parent.iframeHeight - BUTTON_TAB_BLANK_HEIGHT) + "px");
	});	
}

$(document).ready(function()
{
	if(curMenuId != null)
	{
		hideRightMenu(curMenuId);
	}
	document.body.onclick = function()
	{
		if(curMenuId != null)
		{
			hideRightMenu(curMenuId);
		}
	}
	document.oncontextmenu = function()
	{
		if(curMenuId != null)
		{
			hideRightMenu(curMenuId);
		}
	}
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	$(".mux_tree_content, .mux_button").css("height", function(index, value)
	{
		return ((parent.iframeHeight - BUTTON_TAB_BLANK_HEIGHT) + "px");
	});	
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	if(parent.groupAccess == USER)
	{
		DisableButton("applyBtn");
		$("#menu" + MUX_CUSTOM).css("display", "none");
		$("#menu" + MUX_AUTO_ADJUST).css("display", "none");
	}
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	generateOption();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function generateOption()
{
	var data;
	var response;
	var cardArray;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + MUX_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&funType=" + OPER_MUX_APPLY + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			cardArray = response.split(FIRST_DELIMITER);
			if(cardArray[0] == "")
			{
				inCardNum = 0;
			}
			else
			{
				inputArray = cardArray[0].split(SECOND_DELIMITER);
				inCardNum = inputArray.length;
			}
			if(cardArray[1] == "")
			{
				outCardNum = 0;
			}
			else
			{
				outputArray = cardArray[1].split(SECOND_DELIMITER);
				outCardNum = outputArray.length;
			}
			
			updateInput();
			updateOutput();
		}
	}
	xmlHttp.send(null);
}

/*************************************************
Function: 		updateInput
Description: 	输入卡的初始化
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function updateInput()
{
	var inputCard;
	var inCardInfo;
	var inCardValue;
	var option;

	inputCard = $("#inputCard");
	inputCard.empty();
	
	if(inCardNum == 0)
	{
		option = $("<option>").text(noCardList[language]).val(NO_CARD);
		inputCard.append(option);
	}
	else
	{
		for(var i = 0; i < inCardNum; i++) 
		{
			inCardInfo = inputArray[i].split(THIRD_DELIMITER);
			option = $("<option>").text(inCardInfo[0]).val(inCardInfo[1]);
			inputCard.append(option);	
		}
		if(parent.inSlotNo == -1)
		{
			inCardValue = inputCard.get(0).options[0].value;
		}
		else
		{
			inCardValue = parent.inSlotNo;
		}
		inputCard.val(inCardValue);
		changeInput();
	}
}

/*************************************************
Function: 		updateOutput
Description: 	输出卡的初始化
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function updateOutput()
{
	var outputCard;
	var outCardInfo;
	var outCardValue;
	var option;
	
	outputCard = $("#outputCard");
	outputCard.empty();
	
	if(outCardNum == 0)
	{
		option = $("<option>").text(noCardList[language]).val(NO_CARD);
		outputCard.append(option);
	}
	else
	{
		for(var i = 0; i < outCardNum; i++) 
		{		
			outCardInfo = outputArray[i].split(THIRD_DELIMITER);
			option = $("<option>").text(outCardInfo[0]).val(outCardInfo[1]);
			outputCard.append(option);
		}
		if(parent.outSlotNo == -1)
		{
			outCardValue = outputCard.get(0).options[0].value;
		}
		else
		{
			outCardValue = parent.outSlotNo;
		}
		outputCard.val(outCardValue);
		changeOutput();
	}	
}

/*************************************************
Function: 		changeInput
Description: 	输入卡切换
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeInput()
{
	var inCardValue = parseInt($("#inputCard").val(), 10);
	parent.inSlotNo = inCardValue;
	zTree1 = $.fn.zTree.init($("#inputTree"), setting, clone(eval("zInNode" + (inCardValue + 1))));
}

/*************************************************
Function: 		changeOutput
Description: 	输出卡切换
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeOutput()
{
	var outCardValue = parseInt($("#outputCard").val(), 10);
	parent.outSlotNo = outCardValue;
	zTree2 = $.fn.zTree.init($("#outputTree"), setting, clone(eval("zOutNode" + (outCardValue + 1))));
	outputNodes = getOutput(zTree2);
	clearMuxInfo();
}


/*************************************************
Function: 		hideRightMenu
Description: 	隐藏右键菜单
Input: 			menuId:对应的菜单id
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function hideRightMenu(menuId)
{
	$("#" + menuId).css("display", "none");
}

/*************************************************
Function: 		changeMenu
Description: 	改变右键菜单
Input: 			menuId:对应的菜单id;
				event:事件对象
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeMenu(menuId, event)
{
	var curBottomHeight;
	var curMenuHeight;
	if(curMenuId != null)
	{
		hideRightMenu(curMenuId);
	}
	curBottomHeight = $("#mainContent").height() - event.clientY;
	curMenuHeight = $("#" + menuId).height();
	if (curBottomHeight  < curMenuHeight)
	{
		$("#" + menuId).css({"top": event.clientY - (curMenuHeight - curBottomHeight) + "px", "left": (event.clientX + 10) + "px", "display": ""});
	}
	else
	{
		$("#" + menuId).css({"top": event.clientY + "px", "left": (event.clientX + 10) + "px", "display": ""});
	}
	
	curMenuId = menuId;
}

/*************************************************
Function: 		zTreeRightClick
Description: 	树的右键操作
Input: 			event:事件对象;
				treeId:当前树的treeId;
				treeNode:当前操作的树结点
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function zTreeRightClick(event, treeId, treeNode)
{   
	if(!treeNode) 
	{
		if(inCardNum != 0)
		{
			zTree1.cancelSelectedNode();
		}	
		if(outCardNum != 0)
		{
			zTree2.cancelSelectedNode();
		}
		if(curMenuId != null)
		{
			hideRightMenu(curMenuId);
		}
	}
	else if (treeNode && (!treeNode.noR)) 
	{
		/*
		if(event.target.tagName != "a" && $(event.target).parents("a").length == 0) 
		{
			if(inExistFlag == 1)
			{
				zTree1.cancelSelectedNode();
			}
			if(outExistFlag == 1)
			{
				zTree2.cancelSelectedNode();
			}
			for(var i = 0; i < MENU_NUM; i++)
			{
				hideRightMenu(menuIdArray[i]);
			}
		}
		*/
		if(treeId == "inputTree") 
		{
			if(inCardNum != 0)
			{
				zTree1.selectNode(treeNode);
			}
			if(treeNode.movelevel == 1)
			{
				changeMenu("inCardMenu", event);
			}
			else
			{
				changeMenu("inPortMenu", event);
			}
		}
		else if(treeId == "outputTree") 
		{
			if(outCardNum != 0)
			{
				zTree2.selectNode(treeNode);
			}
			if(treeNode.movelevel == 2)
			{				
				changeMenu("outPortMenu", event);
			}
			else if(treeNode.movelevel == 3)
			{
				changeMenu("outProgMenu", event);
				if(parent.BackUpEna == DEVICE_BACKUP)
				{
					$("#outProgMenu").css("display", "");
				}
				else
				{
					$("#outProgMenu").css("display", "none");
				}
			}
			else if(treeNode.movelevel == 5)
			{
				changeMenu("outPidMenu", event);
				if(parent.groupAccess == USER)
				{
					$("#outPidMenu").css("display", "none");
				}
				else
				{
					$("#outPidMenu").css("display", "");
				}
			}
		}
	}
}

/*************************************************
Function: 		moveFocus
Description: 	操作树结点后焦点自动下移
Input: 			curTree:
				treeNode:
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function moveFocus(curTree, treeNode)
{
	var nodes = curTree.getNodesByParam("level", treeNode.level);
	var length = nodes.length;
	for(var i = 0; i < length; i++)
	{
		if(nodes[i].ID == treeNode.ID)
		{
			if(i != length - 1)
			{
				curTree.selectNode(nodes[i + 1]);
			}
			else
			{
				curTree.selectNode(nodes[i]);
			}
			break;
		}
	}
}

/*************************************************
Function: 		moveTreeNode
Description: 	左右箭头复用操作
Input: 			flag:1-TO_RIGHT添加复用,2-TO_LEFT删除复用
Output: 		无
Return: 		无
Others: 		添加复用需要保证输入和输出同时存在；删除复用需要保证存在输出卡
*************************************************/
function moveTreeNode(flag)
{
	if(outCardNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("No output card!");
		}
		else
		{
			alert("无输出卡！");
		}
		return;
	}
	if(flag == TO_RIGHT)
	{
		if(inCardNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("No input card!");
			}
			else
			{
				alert("无输入卡！");
			}
			return;
		}
		moveNodeToRight(zTree1, zTree2);
	}
	else
	{
		moveNodeToLeft(zTree2, zTree1);
	}
}

var MUX_CARD_OR_GBE = 1;
var MUX_PORT = 2;
var MUX_PROGRAM = 3;
var MUX_VIDEO_OR_AUDIO = 4;
var MUX_UNKNOWN_PID = 5;
var MUX_PSI_PID = 6;
var MUX_UNKNOWN_PID_PARENT = 7;
var MUX_MAX_NUM = 256;
var MUX_VIDEO = 1;
var MUX_EMM = 2;

function validateBeforeMux(srcNode, targetNode, targetTree)
{
	var nodes;
	
	if(!srcNode) 
	{
		if(language == ENGLISH)
		{
			alert("Please select an input!");
		}
		else
		{
			alert("请选择输入！");
		}
		return false;
	}
	if(!targetNode)
	{
		if(language == ENGLISH)
		{
			alert("Please select an output!");
		}
		else
		{
			alert("请选择输出！");
		}
		return false;
	}
	
	if((srcNode.movelevel == MUX_CARD_OR_GBE) || (targetNode.movelevel == MUX_CARD_OR_GBE))
	{
		if(language == ENGLISH)
		{
			alert("This could not be multiplexed!");
		}
		else
		{
			alert("不能被复用！");
		}
		return false;
	}	

	if(targetNode.movelevel == MUX_PORT)
	{
		if(srcNode.movelevel == MUX_VIDEO_OR_AUDIO)
		{
			if(language == ENGLISH)
			{
				alert("The video pid and audio pid could not be multiplexed to the port!");
			}
			else
			{
				alert("视音频PID不能复用到端口！");
			}
			return false;
		}
	}
	else if(targetNode.movelevel == MUX_PROGRAM)
	{
		if(srcNode.movelevel != MUX_VIDEO_OR_AUDIO)
		{
			if(language == ENGLISH)
			{
				alert("Only the video pid and audio pid could be multiplexed to the service!");
			}
			else
			{
				alert("只有视音频PID可以复用到节目！");
			}
			return false;
		}
	}
	else
	{
		if(language == ENGLISH)
		{
			alert("The target node could be a port or a service!");
		}
		else
		{
			alert("复用目标只能是端口或节目！");
		}
		return false;
	}
	if(srcNode.type == MUX_VIDEO)
	{
		nodes = targetTree.getNodesByParam("type", MUX_VIDEO, targetNode);
		if(nodes != "")
		{
			if(language == ENGLISH)
			{
				alert("This service already has video element!");
			}
			else
			{
				alert("该节目已经有视频单元了！");
			}
			return false;
		}
	}
	//控制重复复用
	nodes = targetTree.getNodesByParam("srcID", srcNode.ID, targetNode);
	if(nodes != "")
	{
		if(nodes[0].muxtype == srcNode.muxtype)
		{
			if(srcNode.movelevel != MUX_UNKNOWN_PID_PARENT)
			{
				if(language == ENGLISH)
				{
					alert("This service is already in the output!");
				}
				else
				{
					alert("该单元已经被复用！");
				}
				return false;
			}
		}
	}	
	return true;
}

/*************************************************
Function: 		moveNodeToRight
Description: 	添加复用操作
Input: 			leftTree:操作的源树
				rightTree:操作的目的树
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function moveNodeToRight(leftTree, rightTree) 
{
	var srcTree = leftTree;
	var targetTree = rightTree;
	var nodes;
	var length;
	var newNode;
	var sameTargetNode;
	
	var srcNode = srcTree.getSelectedNodes()[0];
	var targetNode = targetTree.getSelectedNodes()[0];
	
	if(validateBeforeMux(srcNode, targetNode, targetTree) == false)
	{
		return;
	}
	
	if((srcNode.movelevel == MUX_UNKNOWN_PID_PARENT) && (targetNode.movelevel == MUX_PORT))  //psi/si表整体复用,已有pid不再复用
	{
		nodes = srcTree.getNodesByParam("movelevel", MUX_PSI_PID, srcNode);
		length = nodes.length;		
		for(var i = 0; i < length; i++)
		{
			newNode = clone(nodes[i]);
			sameTargetNode = targetTree.getNodeByParam("srcID", nodes[i].ID, targetNode);
			if(sameTargetNode != null)
			{
				if(sameTargetNode.muxtype != nodes[i].muxtype)
				{
					if(getInfo(nodes[i], targetNode) == false)
					{
						return;
					}
					targetTree.addNodes(targetNode, [newNode]);
				}				
			}
			else
			{						
				if(getInfo(nodes[i], targetNode) == false)
				{
					return;
				}
				targetTree.addNodes(targetNode, [newNode]);
			}
		}
	}	
	else if((srcNode.movelevel == MUX_PORT) && (targetNode.movelevel == MUX_PORT))  //端口整体复用
	{
		//节目和EMM
		nodes = srcTree.getNodesByParam("movelevel", MUX_PROGRAM, srcNode);
		length = nodes.length;		
		for(var i = 0; i < length; i++)
		{
			newNode = clone(nodes[i]);
			sameTargetNode = targetTree.getNodeByParam("srcID", nodes[i].ID, targetNode);
			if(sameTargetNode == null)  //已有节目不复用
			{
				if(nodes[i].muxtype != MUX_EMM)//EMM信息不被复用
				{					
					if(getInfo(nodes[i], targetNode) == false)
					{
						return;
					}
					targetTree.addNodes(targetNode, [newNode]);
				}
			}
		}
		//非指定PID
		nodes = srcTree.getNodesByParam("movelevel", MUX_UNKNOWN_PID, srcNode);
		length = nodes.length;		
		for(var i = 0; i < length; i++)
		{
			newNode = clone(nodes[i]);
			sameTargetNode = targetTree.getNodeByParam("srcID", nodes[i].ID, targetNode);
			if(sameTargetNode == null)
			{
				if(getInfo(nodes[i], targetNode) == false)
				{
					return;
				}
				targetTree.addNodes(targetNode, [newNode]);
			}
		}
	}
	else
	{
		newNode = clone(srcNode);		
		if(getInfo(srcNode, targetNode) == false)
		{
			return;
		}
		targetTree.addNodes(targetNode, [newNode]);
	}
	moveFocus(srcTree, srcNode);
	/* 复用一个节目后输出端的焦点也下移，在使用过程中可以根据需求打开注释*/
	//moveFocus(targetTree,targetNode);			
}

/*************************************************
Function: 		moveNodeToLeft
Description: 	删除复用操作
Input: 			rightTree:操作的源树
				leftTree:操作的目的树
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function moveNodeToLeft(rightTree, leftTree) 
{
	var srcTree = rightTree;
	var targetTree = leftTree;
	var nodes;
	var length;
	var srcNode = srcTree.getSelectedNodes()[0];
	
	if (!srcNode) 
	{
		if(language == ENGLISH)
		{
			alert("Please select an output!");
		}
		else
		{
			alert("请选择输出！");
		}
		return;
	}
	if(srcNode.movelevel == MUX_CARD_OR_GBE)
	{
		if(language == ENGLISH)
		{
			alert("Please select a legal output!");
		}
		else
		{
			alert("请选择正确的输出！");
		}
		return;
	}
	
	var srcNodeId = stringSplit(srcNode.ID);
	var srcCard = srcNodeId[1] - 1;

	if(srcNode.movelevel == MUX_PORT)//端口下的整体删除
	{
		if(typeof(srcNode.nodes) != "undefined")
		{
			var unknownPidNodes = srcTree.getNodeByParam("movelevel", MUX_UNKNOWN_PID_PARENT, srcNode);
			if(typeof(unknownPidNodes) != "object")
			{
				nodes = srcTree.getNodesByParam("movelevel", MUX_UNKNOWN_PID, unknownPidNodes);
				length = nodes.length;
				for(var i = 0; i < length; i++)
				{
					if(getDelInfo(nodes[i]) == false)
					{
						return;
					}
					srcTree.removeNode(nodes[i]);
				}
			}
			if(srcCard == MAIN_GBE_CARD)
			{
				nodes = srcTree.getNodesByParam("level", 3, srcNode);
			}
			else
			{
				nodes = srcTree.getNodesByParam("level", 2, srcNode);
			}
			length = nodes.length;
			for(var i = 0; i< nodes.length; i++)
			{
				if(getDelInfo(nodes[i]) == false)
				{
					return;
				}
				srcTree.removeNode(nodes[i]);
			}
		}
		moveFocus(srcTree,srcNode);	
	}
	else if(srcNode.movelevel == MUX_UNKNOWN_PID_PARENT)//非指定pid整体删除
	{
		nodes = srcTree.getNodesByParam("movelevel", MUX_UNKNOWN_PID, srcNode);
		length = nodes.length;
		for(var i =0; i < length; i++)
		{
			if(getDelInfo(nodes[i]) == false)
			{
				return;
			}
			srcTree.removeNode(nodes[i]);
		}
	}
	else//单条信息删除
	{
		if(getDelInfo(srcNode) == false)
		{
			return;
		}
		moveFocus(srcTree, srcNode);			
		srcTree.removeNode(srcNode);			
	}	
}

/*************************************************
Function: 		getOutput
Description: 	得到输出树的节目 音视频 非指定pid节点数组
Input: 			zTree:输出树
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function getOutput(zTree)
{	
	var progNodes = zTree.getNodesByParam("movelevel", MUX_PROGRAM);  //所有节目
	var elementNodes = zTree.getNodesByParam("movelevel", MUX_VIDEO_OR_AUDIO);  //所有节目下音、视频 ECM EMMM
	var pidNodes = zTree.getNodesByParam("movelevel", MUX_UNKNOWN_PID); //所有非指定PID
	
	var outputNodes = progNodes.concat(elementNodes, pidNodes);
	return outputNodes;
}

/*************************************************
Function: 		clearMuxInfo
Description: 	删除记录的添加复用和删除复用的信息
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function clearMuxInfo()
{
	addInfo = [];
	delInfo = [];	
}

/*添加复用信息结构体*/
function AddMuxInfo(srcProgID, type, dstPortID)
{
	this.muxtype = type;  //源类型
	this.srcProgID = srcProgID;		//源节目ID
	this.dstPortID = dstPortID;		//目的端口ID
}
/*添加删除信息结构体*/
function AddDelInfo(srcProgID, type)
{
	this.muxtype = type;  //删除的源类型
	this.srcProgID = srcProgID;		//删除的源节目ID
}

/*************************************************
Function: 		getInfo
Description: 	左向右复用时记录复用信息
Input: 			srcNode: 源节点
				targetNode: 目的节点
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function getInfo(srcNode, targetNode)
{
	if(addInfo.length == MUX_MAX_NUM)
	{
		if(language == ENGLISH)
		{
			alert("One operation can only include 256 muxing Info!");
		}
		else
		{
			alert("一次操作最多复用256个！");
		}
		return false;
	}
	addInfo.push(new AddMuxInfo(srcNode.ID, srcNode.muxtype, targetNode.ID));
	return true;
}

/*************************************************
Function: 		getDelInfo
Description: 	右向左删除复用记录信息
Input: 			srcNode: 当前要删除的节点
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function getDelInfo(srcNode)
{
	var outLength = outputNodes.length;
	for(var i = 0; i < outLength; i++)
	{
		if(outputNodes[i].ID == srcNode.ID)
		{
			if(delInfo.length == MUX_MAX_NUM)
			{
				if(language == ENGLISH)
				{
					alert("One operation can only delete 256 muxing Info!");
				}
				else
				{
					alert("一次操作最多删除复用256个！");
				}
				return false;
			}
			delInfo.push(new AddDelInfo(srcNode.ID, srcNode.muxtype));
			return true;
		}
	}
	//删除掉新复用然后又撤销的记录
	var addLength = addInfo.length;
	for(var i = 0; i < addLength; i++)
	{
		if(srcNode.ID == addInfo[i].srcProgID)
		{
			addInfo.splice(i, 1);
			return true;
		}
	}
	return true;
}

function stringSplit(string)
{
	var getString = string.split("_");
	return getString;
}

/*************************************************
Function: 		pageJump
Description: 	右键打开相应的页面或者实现相应的操作
Input: 			index:对应右键菜单
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function pageJump(index)
{
	var selectNode;
	var startMenu = " > " + mainMenu[language] + " > " +  treeMenu[language] + " > ";
	var id;
	var idString;
	var portInfo;
	var progInfo;
	
	if((index == MUX_CARD_REFRESH) || (index == MUX_PORT_REFRESH) || (index == MUX_PSI_PREVIEW))
	{
		selectNode = zTree1.getSelectedNodes()[0];
	}
	else
	{
		selectNode = zTree2.getSelectedNodes()[0];
	}
	id = selectNode.ID;
	idString = stringSplit(id);
	if((index == MUX_PSI_PREVIEW) || (index == MUX_PORT_DETAIL) || (index == MUX_PSI_INTERVAL) || (index == MUX_PSI_EDIT) || (index == MUX_CUSTOM)) 
	{
		if(parseInt(idString[1], 10) - 1 == MAIN_GBE_CARD)
		{
			if(parseInt(idString[2], 10) > ONE_GBE_PORT_NUM)
			{
				var curPortNo = parseInt(idString[2], 10) - ONE_GBE_PORT_NUM;
				portInfo = "(" + cardArray[language] + idString[1] + "-" + gbeArray[language] + GBE_TWO + portArray[language] + curPortNo + ")";
			}
			else
			{
				portInfo = "(" + cardArray[language] + idString[1] + "-" + gbeArray[language] + GBE_ONE + portArray[language] + idString[2] + ")";
			}
		}
		else
		{
			portInfo = "(" + cardArray[language] + idString[1] + "-" + portArray[language] + idString[2] + ")";
		}
		
	}
	else if(index == MUX_PROGRAM_BACKUP)
	{
		if(parseInt(idString[1], 10) - 1 == MAIN_GBE_CARD)
		{
			if(parseInt(idString[2], 10) > ONE_GBE_PORT_NUM)
			{
				var curPortNo = parseInt(idString[2], 10) - ONE_GBE_PORT_NUM;
				progInfo = "(" + cardArray[language] + idString[1] + "-" + gbeArray[language] + GBE_TWO + portArray[language] + curPortNo + progArray[language] + idString[3] + ")";
			}
			else
			{
				progInfo = "(" + cardArray[language] + idString[1] + "-" + gbeArray[language] + GBE_ONE + portArray[language] + idString[2] + progArray[language] + idString[3] + ")";
			}
		}
		else
		{
			progInfo = "(" + cardArray[language] + idString[1] + "-" + portArray[language] + idString[2] + progArray[language] + idString[3] + ")";
		}		
	}
	switch(index)
	{
		case MUX_CARD_REFRESH:
			operation = OPER_CARD_REFRESH;		
			applyData = id;
			pageApply();
			break;
		case MUX_PORT_REFRESH:
			operation = OPER_PORT_REFRESH;
			applyData = id;
			selectNodeTop = $("#" + selectNode.tId + "_span").offset().top;
			selectNodeLeft = $("#" + selectNode.tId + "_span").offset().left;
			selectNodeWidth = $("#" + selectNode.tId + "_span").width();
			pageApply();
			break;
		case MUX_PSI_PREVIEW:
			if(language == ENGLISH)
			{
				self.location.replace("psi_preview_en.asp?ID=" + id + "_0");
			}
			else
			{
				self.location.replace("psi_preview_cn.asp?ID=" + id + "_0");
			}			
			parent.document.getElementById("menuBar").innerHTML = startMenu + $("#menu" + index + " .menu-text").html() + portInfo;
			break;
		case MUX_PORT_DETAIL:
			if(language == ENGLISH)
			{
				self.location.replace("port_detail_en.asp?ID=" + id);
			}
			else
			{
				self.location.replace("port_detail_cn.asp?ID=" + id);
			}
			parent.document.getElementById("menuBar").innerHTML = startMenu + $("#menu" + index + " .menu-text").html() + portInfo;
			break;
		case MUX_PSI_INTERVAL:
			if(language == ENGLISH)
			{
				self.location.replace("psi_interval_en.asp?ID=" + id);
			}
			else
			{
				self.location.replace("psi_interval_cn.asp?ID=" + id);
			}
			parent.document.getElementById("menuBar").innerHTML = startMenu + $("#menu" + index + " .menu-text").html() + portInfo;
			break;
		case MUX_PSI_EDIT:
			if(language == ENGLISH)
			{
				self.location.replace("psi_edit_en.asp?ID=" + id);
			}
			else
			{
				self.location.replace("psi_edit_cn.asp?ID=" + id);
			}
			parent.document.getElementById("menuBar").innerHTML = startMenu + $("#menu" + index + " .menu-text").html() + portInfo;
			break;
		case MUX_CUSTOM:
			if(language == ENGLISH)
			{
				self.location.replace("custom_program_en.asp?ID=" + id);
			}
			else
			{
				self.location.replace("custom_program_cn.asp?ID=" + id);
			}
			parent.document.getElementById("menuBar").innerHTML = startMenu + $("#menu" + index + " .menu-text").html() + portInfo;
			break;
		case MUX_AUTO_ADJUST:
			var confirmPrompt
			if(language == ENGLISH)
			{
				confirmPrompt = "Are you sure to automatically modify the service number and PIDs?";
			}
			else
			{
				confirmPrompt = "确定要自动调整本端口的节目号、PID等信息？";
			}
			if(window.confirm(confirmPrompt))
			{
				operation = OPER_AUTO_ADJUST;
				applyData = id;
				pageApply();
			}
			break;
		case MUX_PROGRAM_BACKUP:
			if(language == ENGLISH)
			{
				self.location.replace("program_backup_en.asp?ID=" + id);
			}
			else
			{
				self.location.replace("program_backup_cn.asp?ID=" + id);
			}			
			parent.document.getElementById("menuBar").innerHTML = startMenu + $("#menu" + index + " .menu-text").html() + progInfo; 
			break;
		case MUX_PID_MODIFY:
			operation = OPER_MODIFY_PID;
			applyData = id;
			$("#newPid").val("");			
			$("#modifyPid").modal();
			break;
		default:
			break;
			
	}
}

/*************************************************
Function: 		modifyPidApply
Description: 	设置修改的PID
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function modifyPidApply()
{
	var returnFlag;
	returnFlag = ValidateParam($("#newPid"), "INT_DEC_HEX", 0, 8191, "<PID>", "<PID>", language);
	if(returnFlag == false)
	{
		return;
	}
	applyData += FIRST_DELIMITER + $("#newPid").val();
	pageApply();
}

function cancelEdit()
{
	$.modal.close();
}

/*************************************************
Function: 		muxApply
Description: 	设置复用
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function muxApply()
{
	var muxData = "";
	var deleteMuxData = "";
	var addLength = addInfo.length;
	var deleteLength = delInfo.length;
	for(var i = 0; i < addLength; i++)
	{
		if(i == 0)
		{
			muxData = addInfo[i].muxtype + THIRD_DELIMITER + addInfo[i].srcProgID + THIRD_DELIMITER + addInfo[i].dstPortID;
		}
		else
		{
			muxData += SECOND_DELIMITER + addInfo[i].muxtype + THIRD_DELIMITER + addInfo[i].srcProgID + THIRD_DELIMITER + addInfo[i].dstPortID;
		}
	}
	for(var i = 0; i < deleteLength; i++)
	{
		if(i == 0)
		{
			deleteMuxData = delInfo[i].muxtype + THIRD_DELIMITER + delInfo[i].srcProgID;
		}
		else
		{
			deleteMuxData += SECOND_DELIMITER + delInfo[i].muxtype + THIRD_DELIMITER + delInfo[i].srcProgID;
		}
	}
	applyData = deleteMuxData + FIRST_DELIMITER +  muxData ;
	operation = OPER_MUX_APPLY;
	pageApply();
}

function pageApply()
{
	var data = "type=" + MUX_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&funType=" + operation + "&setString=";
	data += applyData;
	var xmlHttp = GetHTTPObject();
	var response;
	
	xmlHttp.open("POST", "/goform/formEMR30", true);
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(operation == OPER_PORT_REFRESH)
				{
					$("#ajaxLoading").css({"top": selectNodeTop + "px", "left": selectNodeLeft + selectNodeWidth + 10 + "px", "display": "block"});
					curPortId =  applyData;
					setTimeout("getPortSearchFlag()", 2000);
				}
				else
				{
					self.location.reload(true);
				}				
			}
			else
			{
				alert(returnError[language][response]);
				clearMuxInfo();
			}
		}
	}
	xmlHttp.send(data);
}

function getPortSearchFlag()
{
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + MUX_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&funType=" + operation + "&portId=" + curPortId + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == SEARCHING)
			{
				setTimeout("getPortSearchFlag()", 2000);
			}
			else if(response == RETURN_OK)
			{
				self.location.reload(true);
			}
		}
	}
	xmlHttp.send(null);
}