﻿var getIdArray = ["backupSwitch", "curState", "mainCard", "mainPort", "mainServiceId", "mainServiceName", "mainCurBitrate",  "mainMinRate", "mainMaxRate", "backupCard", "backupPort", "backupServiceId", "backupServiceName", "backupCurBitrate", "backupMinRate", "backupMaxRate"];
var GET_OBJ_NUM = 16;
var setIdArray = ["backupSwitch", "mainMinRate", "mainMaxRate", "backupCard", "backupPort", "backupServiceId",  "backupMinRate", "backupMaxRate"];
var SET_OBJ_NUM = 8;
var id;
var oldId;
var optionArray;
var CUR_STATE = 1;
var MAIN_CARD = 2;
var MAIN_PORT = 3;
var BACKUP_CARD = 9;
var BACKUP_PORT = 10;
var curStateEn = ["", "Main", "Backup"];
var curStateCn = ["", "主路", "备路"];
var curState = [curStateEn, curStateCn];
var ONE_GBE_PORT_NUM = 256;
var cardArray = ["Card", "卡"];
var gbeArray = ["GbE", "网口"];
var portArray = ["Port", "端口"];
var GBE_ONE = 1;
var GBE_TWO = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	oldId = args["ID"];
	var oldIdString = oldId.split("_");
	var idString = [oldIdString[0], oldIdString[1], oldIdString[2], parseInt(oldIdString[3])];
	id = idString.join("_");
	
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	generateOption();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function generateOption()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_BACKUP_LIST + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			optionArray = response.split(FIRST_DELIMITER);
			populateBackupCards();
			displayParam();
		}
	}
	xmlHttp.send(null);
}

function populateBackupCards()
{
	var backupCard;
	var backupCardInfo;
	var option;
	var cardNum = optionArray.length;
	
	backupCard = $("#backupCard");
	backupCard.empty();
	
	if(optionArray[0] == "")
	{
		option = $("<option>").text(noCardList[language]).val(NO_CARD);
		backupCard.append(option);
	}
	else
	{
		for(var i = 0; i < cardNum; i++) 
		{
			backupCardInfo = optionArray[i].split(SECOND_DELIMITER);
			option = $("<option>").text(backupCardInfo[0]).val(backupCardInfo[1]);
			backupCard.append(option);
		}
	}
}

function populateBackupPorts(obj)
{
	var backupPort = $("#backupPort");
	backupPort.empty();
	var option;
	var cardNo = parseInt(obj.val(), 10);
	if(cardNo == NO_CARD)
	{
		option = $("<option>").text(noPortList[language]).val(NO_PORT);
		backupPort.append(option);
	}
	else
	{
		var selectIndex = obj.get(0).selectedIndex;
		var backupPortInfo = optionArray[selectIndex].split(SECOND_DELIMITER);
		var portNum = backupPortInfo.length - 2;
		var displayStr;
		
		for(var i = 0; i < portNum; i++)
		{
			displayStr = getPortDisplayStr(cardNo, parseInt(backupPortInfo[2 + i], 10), language);
			option = $("<option>").text(displayStr).val(parseInt(backupPortInfo[2 + i], 10) - 1);
			backupPort.append(option);
		}
	}
}

function displayBackup()
{
	if(parseInt($("#backupSwitch").val(), 10) == ON)
	{
		$("#curStateTr").css("display", "");
		$("#backupProg").css("display", "");
	}
	else
	{
		$("#curStateTr").css("display", "none");
		$("#backupProg").css("display", "none");
	}
}

function displayParam()
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var infoData;
	var backupCard = $("#backupCard");
	var backupPort = $("#backupPort");

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PROGRAM_BACKUP_MUX + "&cmd=" + GET + "&id=" + id + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < GET_OBJ_NUM; i++)
				{
					if(i == CUR_STATE)
					{
						$("#" + getIdArray[i]).html(curState[language][parseInt(data[i], 10)]);
					}
					else if(i == BACKUP_CARD)
					{
						if(data[i] == "")
						{
							$("#" + getIdArray[i]).val(backupCard.get(0).options[0].value);
						}
						else
						{
							$("#" + getIdArray[i]).val(data[i]);
						}
						populateBackupPorts(backupCard);
					}
					else if(i == BACKUP_PORT)
					{
						if(data[i] == "")
						{
							$("#" + getIdArray[i]).val(backupPort.get(0).options[0].value);
						}
						else
						{
							$("#" + getIdArray[i]).val(data[i]);
						}
					}
					else if((i == 0) || ((i >= 7) && (i <= 11)) || (i == 14) || (i == 15)) 
					{
						$("#" + getIdArray[i]).val(data[i]);
					}
					else if(i == MAIN_CARD)
					{
						var cardString = cardArray[language] + parseInt(data[i], 10);
						$("#" + getIdArray[i]).html(cardString);
					}
					else if(i == MAIN_PORT)
					{
						if(parseInt(data[MAIN_CARD], 10) - 1 == MAIN_GBE_CARD)
						{
							var portString;
							if(parseInt(data[i], 10) > ONE_GBE_PORT_NUM)
							{
								portString = gbeArray[language] + GBE_TWO + portArray[language] + (parseInt(data[i], 10) - ONE_GBE_PORT_NUM);
							}
							else
							{
								portString = gbeArray[language] + GBE_ONE + portArray[language] + parseInt(data[i], 10);
							}
						}
						else
						{
							portString = portArray[language] + parseInt(data[i], 10);
						}
						$("#" + getIdArray[i]).html(portString);
					}
					else
					{
						$("#" + getIdArray[i]).html(data[i]);
					}
						
				}
				displayBackup();
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PROGRAM_BACKUP_MUX + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;

	for(var i = 0; i < SET_OBJ_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + setIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + setIdArray[i]).val();
		}
	}
	
	return data;
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#" + setIdArray[1]), "INT_DEC", 0, 65535, "<Main Bitrate Lower Limit(Kbps)>", "<主路码率下限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + setIdArray[2]), "INT_DEC", 0, 65535, "<Main Bitrate Upper Limit(Kbps)>", "<主路码率上限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + setIdArray[5]), "INT_DEC_HEX", 1, 65535, "<Backup Service ID>", "<备路节目号>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + setIdArray[6]), "INT_DEC", 0, 65535, "<Backup Bitrate Lower Limit(Kbps)>", "<备路码率下限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + setIdArray[7]), "INT_DEC", 0, 65535, "<Backup Bitrate Upper Limit(Kbps)>", "<备路码率上限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if(parseInt($("#mainMinRate").val(), 10) >= parseInt($("#mainMaxRate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The main bitrate lower limit should be smaller than the main bitrate upper limit!");
		}
		else
		{
			alert("主路码率下限必须小于主路码率上限！");
		}
		return false
	}
	if(parseInt($("#backupMinRate").val(), 10) >= parseInt($("#backupMaxRate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The backup bitrate lower limit should be smaller than the backup bitrate upper limit!");
		}
		else
		{
			alert("备路码率下限必须小于备路码率上限！");
		}
		return false
	}
	
	return true;
}
