﻿var dvbIdArray = ["patInterval", "pmtInterval", "catInterval", "nitcInterval", "nitoInterval", "sdtcInterval", "sdtoInterval", "batInterval"];
var dvbCheckArray = ["patCheck", "pmtCheck", "catCheck", "nitcCheck", "nitoCheck", "sdtcCheck", "sdtoCheck", "batCheck"];
var DVB_NUM = 8;

var atscIdArray = ["patInterval", "pmtInterval", "catInterval", "vctInterval", "mgtInterval", "sttInterval"];
var atscCheckArray = ["patCheck", "pmtCheck", "catCheck", "vctCheck", "mgtCheck", "sttCheck"];
var ATSC_NUM = 6;

var atscDefaultValue = [100, 400, 0, 350, 150, 0];

var NITC = 3;
var VCT = 9;
var ROW_NUM_ALL = 12;

var objIdArray = [dvbIdArray, atscIdArray];
var objCheckArray = [dvbCheckArray, atscCheckArray];
var ROW_NUM = [DVB_NUM, ATSC_NUM];

var id;
var identifyData;
var DVB = 0;
var ATSC = 1;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	id = args["ID"];
	
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	
	$("input[type=checkbox]").live("click", function()
	{
		this.style.backgroundColor = "#feffe0";
		if(parent.groupAccess == USER)
		{
			DisableButton("applyBtn");
		}
		else
		{
			EnableButton("applyBtn");
		}
		if($(this).prop("checked") == true)
		{
			$(this).parent().prev().children().attr("disabled", false);
		}
		else
		{
			$(this).parent().prev().children().attr("disabled", true);
		}
	});
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("defaultBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	EnableButton("defaultBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PSI_INTERVAL + "&cmd=" + GET + "&id=" + id + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 1], 10);
				if(identifyData == DVB)
				{
					for(var i = NITC; i < VCT; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "");
					}
					for(var i = VCT; i < ROW_NUM_ALL; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "none");
					}
				}
				else
				{
					for(var i = NITC; i < VCT; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "none");
					}
					for(var i = VCT; i < ROW_NUM_ALL; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "");
					}
				}
				for(var i = 0; i < ROW_NUM[identifyData]; i++)
				{
					$("#" + objIdArray[identifyData][i]).val(data[i]);
					if(parseInt(data[i], 10) == 0)
					{
						$("#" + objCheckArray[identifyData][i]).prop("checked", false);
						$("#" + objIdArray[identifyData][i]).attr("disabled", true);
					}
					else
					{
						$("#" + objCheckArray[identifyData][i]).prop("checked", true);
						$("#" + objIdArray[identifyData][i]).attr("disabled", false);
					}
				}
				if(identifyData == DVB)
				{
					$("#tableSwitch").val(data[length - 2]);
				}
			    refreshFlag = true;
			}			
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PSI_INTERVAL + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var rowData;
	var data;
	for(var i = 0; i < ROW_NUM[identifyData]; i++)
	{
		if($("#" + objCheckArray[identifyData][i]).prop("checked") == true)
		{
			rowData =  $("#" + objIdArray[identifyData][i]).val();
		}
		else
		{
			rowData = 0;
		}
		if(i == 0)
		{
			data = rowData;
		}
		else
		{
			data += FIRST_DELIMITER + rowData;
		}
	}
	if(identifyData == DVB)
	{
		data += FIRST_DELIMITER + $("#tableSwitch").val();
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	
	if($("#" + objCheckArray[identifyData][0]).prop("checked") == true)
	{
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][0]), "INT_DEC", 50, 65535, "<PAT Interval>", "<PAT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		
	}
	if($("#" + objCheckArray[identifyData][1]).prop("checked") == true)
	{
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][1]), "INT_DEC", 50, 65535, "<PMT Interval>", "<PMT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		
	}
	if($("#" + objCheckArray[identifyData][2]).prop("checked") == true)
	{
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][2]), "INT_DEC", 50, 65535, "<CAT Interval>", "<CAT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		
	}
	if(identifyData == DVB)
	{
		if($("#" + objCheckArray[identifyData][3]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][3]), "INT_DEC", 50, 65535, "<NIT(Actual) Interval>", "<NIT(当前)发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
		if($("#" + objCheckArray[identifyData][4]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][4]), "INT_DEC", 50, 65535, "<NIT(others) Interval>", "<NIT(其他)发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
		if($("#" + objCheckArray[identifyData][5]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][5]), "INT_DEC", 50, 65535, "<SDT(Actual) Interval>", "<SDT(当前)发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
		if($("#" + objCheckArray[identifyData][6]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][6]), "INT_DEC", 50, 65535, "<SDT(others) Interval>", "<SDT(其他)发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
		if($("#" + objCheckArray[identifyData][7]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][7]), "INT_DEC", 50, 65535, "<BAT Interval>", "<BAT发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
	}
	else
	{
		if($("#" + objCheckArray[identifyData][3]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][3]), "INT_DEC", 50, 65535, "<VCT Interval>", "<VCT发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
		if($("#" + objCheckArray[identifyData][4]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][4]), "INT_DEC", 50, 65535, "<MGT Interval>", "<MGT发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
		if($("#" + objCheckArray[identifyData][5]).prop("checked") == true)
		{
			returnFlag = ValidateParam($("#" + objIdArray[identifyData][5]), "INT_DEC", 50, 65535, "<STT Interval>", "<STT发表间隔>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
	}
	return true;
}

function resetInterval()
{
	var i;
	
	if(identifyData == DVB)
	{
		for(i = 0; i < NITC; i++)
		{
			$("#" + objIdArray[identifyData][i]).val(300);
			$("#" + objCheckArray[identifyData][i]).prop("checked", true);
			$("#" + objIdArray[identifyData][i]).attr("disabled", false);
		}
		for(i = NITC; i < ROW_NUM[identifyData]; i++)
		{
			$("#" + objIdArray[identifyData][i]).val(1000);
			$("#" + objCheckArray[identifyData][i]).prop("checked", true);
			$("#" + objIdArray[identifyData][i]).attr("disabled", false);
		}
	}
	else
	{
		for(i = 0; i < ROW_NUM[identifyData]; i++)
		{
			$("#" + objIdArray[identifyData][i]).val(atscDefaultValue[i]);
			if(atscDefaultValue[i] == 0)
			{
				$("#" + objCheckArray[identifyData][i]).prop("checked", false);
				$("#" + objIdArray[identifyData][i]).attr("disabled", true);
			}
			else
			{
				$("#" + objCheckArray[identifyData][i]).prop("checked", true);
				$("#" + objIdArray[identifyData][i]).attr("disabled", false);
			}
		}
	}
	if(parent.groupAccess == USER)
	{
		DisableButton("applyBtn");
	}
	else
	{
		EnableButton("applyBtn");
	}
}