﻿psiType = SDTO;

//menu定义
var MENU_ADD_PROG = 1;
var MENU_PROG = 2;

var menuIdArray = ["modifyTable", "addProgram", "programMenu", "", "", "descMenu"];
var MENU_NUM = 6;

var objIdArray = ["serviceId", "runStatus", "caMode"];
var ROW_NUM = 3;

var actionType = SET;

function modifyTable()
{
	actionType = SET;
	operation = OPER_TABLE;
	displayParam();
	$("#table").css("display", "");
	$("#program").css("display", "none");
	if(language == ENGLISH)
	{
		$("#editHeader").html("Table Info");
	}
	else
	{
		$("#editHeader").html("表信息");
	}	
	$("#editInfo").modal();
}

function addProgram()
{
	actionType = ADD;
	operation = OPER_PROG;	
	editProgram();
}

function modifyProgram()
{
	actionType = SET;
	operation = OPER_PROG;	
	displayParam();
	editProgram();
}

function editProgram()
{
	$("#table").css("display", "none");
	$("#program").css("display", "");
	if(language == ENGLISH)
	{
		$("#editHeader").html("Service Info");
	}
	else
	{
		$("#editHeader").html("节目信息");
	}
	$("#editInfo").modal();
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + psiType + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&id=" + id + "&operation=" + operation + "&index=" + nodeIndex + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);			
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				if(operation == OPER_TABLE)
				{
					$("#streamId").val(data[0]);
					$("#networkId").val(data[1]);
					$("#versionNumber").val(data[2]);
				}
				else if(operation == OPER_PROG)
				{
					for(var i = 0; i < ROW_NUM; i++)
					{
						$("#" + objIdArray[i]).val(data[i]);
					}
				}
				refreshFlag = true;										
			}			
		}
	}
	xmlHttp.send(null);	
}

function editPageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + psiType + "&cmd=" + actionType + "&language=" + language + "&slotNo=" + slotNo + "&id=" + id + "&operation=" + operation + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(actionType == ADD)
				{
					if(language == ENGLISH)
					{
						alert("Add Successfully!");
					}
					else
					{
						alert("添加成功！");
					}
				}
				else if(actionType == SET)
				{
					if(language == ENGLISH)
					{
						alert("Set Successfully!");
					}
					else
					{
						alert("设置成功！");
					}
				}		
			}
			else
			{
				alert(returnError[language][response]);
			}
			self.location.reload(true);
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	if(operation == OPER_TABLE)
	{
		data = $("#streamId").val() + FIRST_DELIMITER + $("#networkId").val() + FIRST_DELIMITER + $("#versionNumber").val();
	}
	else if(operation == OPER_PROG)
	{
		for( var i = 0; i < ROW_NUM; i++)
		{
			if(i == 0)
			{
				if(actionType == ADD)
				{
					data = $("#" + objIdArray[i]).val();
				}
				else
				{
					data = nodeIndex + FIRST_DELIMITER + $("#" + objIdArray[i]).val();
				}
			}
			else
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
			}
		}
	}
	return data;
}

function paramCheck()
{
	var returnFlag;
	if(operation == OPER_TABLE)
	{
		returnFlag = ValidateParam($("#streamId"), "INT_DEC", 0, 65535, "<TS_ID>", "<流ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#networkId"), "INT_DEC", 0, 65535, "<Network ID>", "<网络ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#versionNumber"), "INT_DEC", 0, 31, "<Version Number>", "<版本号>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(operation == OPER_PROG)
	{
		returnFlag = ValidateParam($("#serviceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;	
}

function deleteProgram()
{	
	operation = OPER_PROG;
	var confirmPrompt;	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the service?";
	}
	else
	{
		confirmPrompt = "确定要删除当前节目吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		deleteApply();
	}	
}