﻿var objIdArray = ["trapIp1", "trapIp2", "trapIp3", "trapInterval", "language", "backupAlarm"];
var ROW_NUM = 6;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();	
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayBackupAlarm();
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var rowData;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + ALARM_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				refreshFlag = true;		
			}			
		}
	}
	xmlHttp.send(null);	
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + ALARM_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

/*************************************************
Function: 		displayBackupAlarm
Description: 	用于动态显示页面备份告警参数的函数
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function displayBackupAlarm()
{
	if(parent.BackUpEna == DEVICE_BACKUP)
	{

		$("#backupAlarmRow").css("display", "");
	}
	else
	{
		$("#backupAlarmRow").css("display", "none");
	}
}

function paramCheck()
{
 	var returnFlag;
	returnFlag = ValidateIP($("#trapIp1"), "UNICAST_IP_ADDR", "<Trap IP Address 1>", "<告警IP地址1>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateIP($("#trapIp2"), "UNICAST_IP_ADDR", "<Trap IP Address 2>", "<告警IP地址2>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateIP($("#trapIp3"), "UNICAST_IP_ADDR", "<Trap IP Address 3>", "<告警IP地址3>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#trapInterval"), "INT_DEC",  0, 65535, "<Trap Interval(min)>", "<告警间隔(min)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;	
}