﻿var sntpIdArray = ["sntpStatus", "sntpMainServerIp", "sntpBackupServerIp", "utcOffsetList", "syncInterval", "syncTimeout"];
var SNTP_NUM = 6;
var newTimeIdArray = ["newTimeYear", "newTimeMonth", "newTimeDay", "newTimeHour", "newTimeMinute", "newTimeSecond"];
var DEFAULT_TIME = ["1970", "12", "31", "12", "12", "12"];
var TIME_NUM = 6;
var sntpDisplayIdArray = ["sntpMainIpRow", "sntpBackupIpRow", "utcOffsetRow", "syncIntervalRow", "syncTimeoutRow", "lastSyncRow"];
var SNTP_DISPLAY_NUM = 6;
var getTimeHour;
var	getTimeMin;
var	getTimeSec;
var DISABLE = 0;
var ENABLE = 1;
var currentTimeArray = new Array();

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	setInterval("updateClockLocal()", 1000);
});

function funcUpdateDisplay() 
{	 
	//DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	clearNewTimeFields();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
}

function clearNewTimeFields()
{
	for(var i = 0; i < TIME_NUM; i++)
	{
		$("#" + newTimeIdArray[i]).val("");
		$("#" + newTimeIdArray[i]).attr("disabled", true);
	}
}

function displayParam() 
{
	var rowData;
	var data;
	var length;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CLOCK_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				currentTimeArray[0] = data[0];
				getTimeHour = parseInt(data[1], 10);
				getTimeMin = parseInt(data[2], 10);
				getTimeSec = parseInt(data[3], 10);
				currentTimeArray[1] = data[1] + ":" + data[2] + ":" + data[3];
				currentTimeArray[2] = data[4];				
				$("#currentTime").html(currentTimeArray.join(" "));
				
				for(var i = 0; i < SNTP_NUM; i++)
				{
					$("#" + sntpIdArray[i]).val(data[i + 5]);
				}
				$("#lastSyncTime").html(data[length - 1]);	
				
				refreshFlag = true;
				handleSyncStatus();
			}
		}
	}
	xmlHttp.send(null);
}

/*************************************************
Function: 		updateClockLocal
Description: 	用于本地时钟计数
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function updateClockLocal()
{
	var tempSecond;
    var tempMinute;
    var tempHour;

    if((++getTimeSec) == 60)
    {
        getTimeSec = 0;
        if((++getTimeMin) == 60)
        {
            getTimeMin = 0;
            if((++getTimeHour) == 24)
            {
                getTimeHour = 0;
				displayParam(); 
			}
        }
    }
    if(getTimeSec < 10)
	{
    	tempSecond = "0" + getTimeSec;
	}
    else
	{
    	tempSecond = getTimeSec;
	}
    if(getTimeMin < 10)
	{
    	tempMinute = "0" + getTimeMin;
	}
    else
	{
    	tempMinute = getTimeMin;
	}
    if(getTimeHour < 10)
	{
    	tempHour = "0" + getTimeHour;
	}
	else
	{
		tempHour = getTimeHour;
	}
	currentTimeArray[1] = tempHour + ":" + tempMinute + ":" + tempSecond;
    $("#currentTime").html(currentTimeArray.join(" "));
}

/*************************************************
Function: 		handleSyncStatus
Description: 	用于同步相关参数的动态隐藏
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function handleSyncStatus()
{
	var sntpStatus = parseInt($("#sntpStatus").val(), 10);
	
	for(var i = 0; i < SNTP_DISPLAY_NUM; i++)
	{
		if(sntpStatus == DISABLE)
		{
			$("#" + sntpDisplayIdArray[i]).css("display", "none");
		}
		else
		{
			$("#" + sntpDisplayIdArray[i]).css("display", "");
		}
	}
}

/*************************************************
Function: 		changeNewTime
Description: 	用于新时间设置是否可写
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeNewTime()
{
	var obj = $("#newTimeflag");
	
	if(obj.prop("checked"))
	{
		for(var i = 0; i < newTimeIdArray.length; i++)
		{
			$("#" + newTimeIdArray[i]).attr("disabled", false);		  
		}
	}
	else
	{
		for(var i = 0; i < newTimeIdArray.length; i++)
		{
		  	$("#" + newTimeIdArray[i]).attr("disabled", true);		  
		}
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CLOCK_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	var i;
	
	if($("#newTimeflag").prop("checked"))
	{
		data = 1;
		for(i = 0; i < TIME_NUM; i++)
		{
			data += FIRST_DELIMITER + $("#" + newTimeIdArray[i]).val();  
		}
	}
	else
	{
		data = 0;
		for(i = 0; i < TIME_NUM; i++)
		{
			data += FIRST_DELIMITER + DEFAULT_TIME[i];  
		}
	}
	
	for(i = 0; i < SNTP_NUM; i++)
	{
		data += FIRST_DELIMITER + $("#" + sntpIdArray[i]).val();	  
	}
	
    return data;
}

function paramCheck()
{
 	var returnFlag;
	if($("#newTimeflag").prop("checked"))
	{
		returnFlag = ValidateParam($("#" + newTimeIdArray[0]), "INT_DEC", 1970, 2100, "<New Time Year>", "<新时间 年>", language);
		if(returnFlag == false)
		{
			return false;
		}		
		returnFlag = ValidateParam($("#" + newTimeIdArray[1]), "INT_DEC", 1, 12, "<New Time Month>", "<新时间 月>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + newTimeIdArray[2]), "INT_DEC", 1, 31, "<New Time Day>", "<新时间 日>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(validateNewTimeDay() == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + newTimeIdArray[3]), "INT_DEC", 0, 23, "<New Time Hour>", "<新时间 时>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + newTimeIdArray[4]), "INT_DEC", 0, 59, "<New Time Minute>", "<新时间 分>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + newTimeIdArray[5]), "INT_DEC", 0, 59, "<New Time Second>", "<新时间 秒>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(parseInt($("#sntpStatus").val(), 10) != DISABLE)
	{
		returnFlag = ValidateIP($("#sntpMainServerIp"), "GATEWAY", "<Main SNTP Server>", "<主服务器IP地址>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateIP($("#sntpBackupServerIp"), "GATEWAY", "<Backup SNTP Server>", "<备服务器IP地址>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#syncInterval"), "INT_DEC", 1, 65535, "<Synchronization Interval(min)>", "<时钟同步间隔(min)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#syncTimeout"), "INT_DEC", 1, 65, "<Synchronization Timeout(s)>", "<时钟同步超时(s)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;	
}

/*************************************************
Function: 		checkLeapYear
Description: 	用于判断当前年份是闰年平年
Input: 			data: year
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function checkLeapYear(data)
{
	if((data % 4) == 0)
	{
		if((data % 100) != 0)
		{
			return true;
		}
		else
		{
			if((data % 400) == 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
	}
	return false;
}

/*************************************************
Function: 		checkLeapYear
Description: 	用于判断当前月份天数是否合法
Input: 			data: year
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function validateNewTimeDay()
{
	var invalidFlag = 0;
	var maxDay;
	var curNewYear = parseInt($("#newTimeYear").val(), 10);
	var curNewMonth = parseInt($("#newTimeMonth").val(), 10);
	var curNewDay = parseInt($("#newTimeDay").val(), 10);
	switch(curNewMonth)
	{
		case 1:
		case 3:
		case 5:
		case 7:
		case 8:
		case 10:
		case 12:
			if(curNewDay > 31)
			{
				invalidFlag = 1;
				maxDay = 31;
			}
			break;
		case 2:
			if(checkLeapYear(curNewYear) == true)
			{
				if(curNewDay > 29)
				{
					invalidFlag = 1;
					maxDay = 29;
				}
			}
			else
			{
				if(curNewDay > 28)
				{
					invalidFlag = 1;
					maxDay = 28;
				}
			}
			break;
		default:
			if(curNewDay > 30)
			{
				invalidFlag = 1;
				maxDay = 30;
			}
			break;
	}
	if(invalidFlag == 1)
	{
		if(language == ENGLISH)
		{
			alert("Maximum number of days in this month is " + maxDay);
		}
		else
		{
			alert("本月最大的天数为" + maxDay);
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	else
	{
		return true;	
	}
}