﻿var objIdArray = ["deviceName", "sidFormat", "pidFormat", "psiPidSwitch", "outPsiVersionNum", "bitrateStatistic", "deviceMode", "powerUnitCfg", "powerType", "gbeCardMode"];
var ROW_NUM = 10;
var getDeviceMode;
var DEVICE_MODE = 6;
var POWER_CONFIG = 7;
var POWER_TYPE = 8;
var GBE_CARD_MODE = 9;
var DUAL_POWER = 0;
var POWER1 = 1;
var POWER2 = 2;
var DISABLE = 0;
var ENABLE = 1;
var typeDisplay = ["Type", "类型"];
var specialType = ["Unknown", "未知"];
var identifyData;
var NO_LICENSE = 0;
var oldGbeCardMode;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();	
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var rowData;
	var length;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + DEVICE_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				identifyData = data[1];
				rowData = data[0].split(SECOND_DELIMITER);
				length = rowData.length;
				if(identifyData == NO_LICENSE)
				{
					$("#gbeCardModeTr").css("display", "none");
				}
				else
				{
					$("#gbeCardModeTr").css("display", "");
				}
				for(var i = 0; i < ROW_NUM; i++)
				{
					if(i == POWER_CONFIG)
					{
						if((rowData[i] != DUAL_POWER) && (rowData[i] != POWER1) && (rowData[i] != POWER2))
						{
							$("#powerConfig").css("display", "none");
						}
						else
						{
							$("#powerConfig").css("display", "");
							$("#" + objIdArray[i]).val(rowData[i]);
						}
					}
					else if(i == POWER_TYPE)
					{
						if(rowData[i] == -1)
						{
							$("#" + objIdArray[i]).html(specialType[language]);
						}
						else
						{
							$("#" + objIdArray[i]).html(typeDisplay[language] + (parseInt(rowData[i], 10) + 1));
						}						
					}
					else
					{
						$("#" + objIdArray[i]).val(rowData[i]);
					}					
				}
				oldGbeCardMode = rowData[GBE_CARD_MODE];
				$("#caIp").html("<a target='_blank' href='http://" + rowData[length - 1] + "'>" + rowData[length - 1] + "</a>");
				getDeviceMode = parseInt(rowData[DEVICE_MODE], 10);
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var sureApplyFlag = false;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	if(oldGbeCardMode != parseInt($("#gbeCardMode").val(), 10))
	{
		var confirmPrompt;
		if(language == ENGLISH)
		{
			confirmPrompt = "Are you sure to modify the mode?If sure,the device will be restarted!";
		}
		else if(language == CHINESE)
		{
			confirmPrompt = "确定要修改主千兆卡模式吗？点击确定，设备将自动重启！";
		}
		if(window.confirm(confirmPrompt))
		{
			sureApplyFlag = true;
		}
	}
	else
	{
		sureApplyFlag = true;
	}
	if(sureApplyFlag == true)
	{
		data = "type=" + DEVICE_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
		data += generateData();
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					applyFlag = true;
				}
				else
				{
					alert(returnError[language][response]);
				}
				GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
				applyFlag = false;  //设置标识符恢复为false
				changeDeviceMode();
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else if(i == POWER_TYPE)
		{
			continue;
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	returnFlag = ValidateParam($("#deviceName"), "LENGTH", 0, 31, "<Device Name>", "<设备名称>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#deviceName"), language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;	
}

/*************************************************
Function: 		changeDeviceMode
Description: 	用于设备模式更改时页面的提示
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeDeviceMode()
{	
	if(parseInt($("#deviceMode").val(), 10) != getDeviceMode)
	{
		if(language == ENGLISH)
		{
			alert("Device mode has been changed, Please restart the device!");
		}
		else
		{
			alert("设备模式已更改，建议重启设备！");
		}
	}
}