﻿var objIdArray = ["mainCard", "mainPort", "mainServiceId", "mainServiceName", "backupCard", "backupPort", "backupServiceId", "backupServiceName", "workState"];
var rowNum = 0;
var initRow = true;
var curRespRowNum;
var rowIndex;

var COL_NUM = 9;
var portDataArray = [];
var outSlotNo;

var MAIN_PORT = 1;
var BACKUP_PORT = 5;
var WORK_STATE = 8;
var INVALID = 0;
var MAIN = 1;
var BACKUP = 2;
var workStateEn = ["Invalid", "Main", "Backup"];
var workStateCn = ["无效", "主路", "备路"];
var workState = [workStateEn, workStateCn];
var OTHER = 7;

var mainMenu = ["Backup", "备份"];
var treeMenu = ["Service Backup", "节目备份"];
var detailMenu = ["Detail Edit", "详细编辑"];
var cardArray = ["Card", "卡"];
var gbeArray = ["GbE", "网口"];
var portArray = ["Port", "端口"];
var progArray = ["Service", "节目"];
var ONE_GBE_PORT_NUM = 256;
var GBE_ONE = 1;
var GBE_TWO = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	outSlotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	if(outSlotNo != OTHER)
	{
		$("#backupConfigDiv").css("display", "");
	}
	funcUpdateDisplay();
	
	if(parent.groupAccess != USER)
	{
		$("input[type=checkbox]").live("click", function()
		{
			EnableButton("deleteBtn");	
		});
	}
});

function funcUpdateDisplay() 
{		
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("deleteBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	PageLoadStatus(false);
	$("input[type=checkbox]").prop("checked", false);
}

function checkAll()
{
	for(var i = 0; i < rowNum; i++)
	{
		$("#check" + (i + 1)).prop("checked", $("#checkAll").prop("checked"));
	}
}

function displayParam() 
{
	var data;
	var rowData;
	var response;
	var indexInfo;
	var curRowNum;
	var xmlHttp = GetHTTPObject();
	if(initRow)
	{
		rowIndex = 0;		
	}

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PROGRAM_BACKUP + "&cmd=" + GET + "&rowIndex=" + rowIndex + 
		"&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 2;
				rowData = data[curRespRowNum].split(SECOND_DELIMITER);
				$("#backupMode").val(rowData[0]);
				$("#mbSwitchTime").val(rowData[1]);
				$("#bmSwitchTime").val(rowData[2]);
				indexInfo = data[curRespRowNum + 1].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);				
				curRowNum = $("#dataTable tr").filter(".mainCaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					DrawTableTwoRow("dataTable", "mainDataRow", "mainCaseRow", "backupDataRow", "backupCaseRow", rowIndex);
				}
				else if(curRowNum > rowNum)
				{
					DrawTableTwoRow("dataTable", "mainDataRow", "mainCaseRow", "backupDataRow", "backupCaseRow", rowNum);
				}
				if(curRespRowNum != 0)
				{
					updateTableData(data);
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					EnableButton("refreshBtn");
					initRow = true;
					refreshFlag = true;
				}
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = (rowIndex - curRespRowNum); i < rowIndex; i++)
	{
		index = i + 1;
		rowData = data[i - (rowIndex - curRespRowNum)].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			if((j == MAIN_PORT)||(j == BACKUP_PORT))
			{
				$("#" + objIdArray[j] + index).html(getPortDisplayStr((parseInt(rowData[j - 1], 10) - 1), parseInt(rowData[j], 10), language));
				if(j == MAIN_PORT)
				{
					portDataArray[index] = rowData[j];
				}
			}
			else if(j == WORK_STATE)
			{
				if(parseInt(rowData[j], 10) == INVALID)
				{
					$("#modify" + index).css("display", "none");
				}
				else
				{
					$("#modify" + index).css("display", "");
				}
				$("#" + objIdArray[j] + index).html(workState[language][parseInt(rowData[j], 10)]);
			}
			else
			{
				$("#" + objIdArray[j] + index).html(rowData[j]);
			}			
		}
	}
}

function pageApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(paramCheck() == false)
	{
		return;
	}

	data = "type=" + PROGRAM_BACKUP + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&setString=";		
	data += $("#backupMode").val() + FIRST_DELIMITER + $("#mbSwitchTime").val() + FIRST_DELIMITER + $("#bmSwitchTime").val();
	
	xmlHttp.open("POST", "/goform/formEMR30", true);
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText));
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#mbSwitchTime"), "INT_DEC", 0, 65535, "<M-B Switching Delay(s)>", "<主备切换延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#bmSwitchTime"), "INT_DEC", 0, 65535, "<B-M Switching Delay(s)>", "<备主切换延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

/*************************************************
Function: 		deleteBackup
Description: 	用于删除备份
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function deleteBackup()
{
	var data;
	var rowData;
	var index;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deleteBackup = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the checked backup?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中的备份吗?";
	}
	if(window.confirm(confirmPrompt))
	{
	
		data = "type=" + PROGRAM_BACKUP + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&outSlotNo=" + outSlotNo + "&setString=";	

		for(var i = 0; i < rowNum; i++)
		{
			index = i + 1;
			if($("#check" + index).prop("checked") == true)
			{
				rowData = parseInt($("#mainCard" + index).html()) + SECOND_DELIMITER + portDataArray[index] + SECOND_DELIMITER + parseInt($("#mainServiceId" + index).html());
				if(deleteNum == 0)
				{
					deleteBackup = rowData;
				}
				else
				{
					deleteBackup += FIRST_DELIMITER + rowData;
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one backup at least!");
			}
			else
			{
				alert("请至少选中一个备份！");
			}
			return;
		}
		data += deleteBackup;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText));
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("Service backup delete successfully!");
					}
					else if(language == CHINESE)
					{
						alert("备份删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function modifyBackup(obj)
{
	var curGbeNo;
	var curPortNo;
	var detailString;
	var index = GetIndexFromId(obj, 11);
	var outProgIdArray = [];
	outProgIdArray.push("O", $("#mainCard" + index).html(), portDataArray[index], parseInt($("#mainServiceId" + index).html()));
	outProgId = outProgIdArray.join("_");
	if(parseInt($("#mainCard" + index).html(), 10) - 1 == MAIN_GBE_CARD)
	{
		if(parseInt(outProgIdArray[2], 10) > ONE_GBE_PORT_NUM)
		{
			curGbeNo = GBE_TWO;
			curPortNo = parseInt(outProgIdArray[2], 10) - ONE_GBE_PORT_NUM;
		}
		else
		{
			curGbeNo = GBE_ONE;
			curPortNo = outProgIdArray[2];
		}
		detailString = " > " + mainMenu[language] + " > " + treeMenu[language] + " > " + detailMenu[language] + " (" + cardArray[language] + outProgIdArray[1] + "-" + gbeArray[language] + curGbeNo + portArray[language] + curPortNo + progArray[language] + outProgIdArray[3] + ")";
	}
	else
	{
		detailString = " > " + mainMenu[language] + " > " + treeMenu[language] + " > " + detailMenu[language] + " (" + cardArray[language] + outProgIdArray[1] + "-" + portArray[language] + outProgIdArray[2] + progArray[language] + outProgIdArray[3] + ")";
	}
	if(language == ENGLISH)
	{
		self.location.replace("../mux/program_backup_en.asp?ID=" + outProgId);		
	}
	else
	{
		self.location.replace("../mux/program_backup_cn.asp?ID=" + outProgId);
	}
	parent.document.getElementById( "menuBar").innerHTML = detailString;
}
