﻿var slotNo = 0xff;
var NETWORK_CONFIG = 1;
var ALARM_CONFIG = 2;
var LICENSE_CONFIG = 3;
var CLOCK_CONFIG = 4;
var PSI_REFRESH = 5;
var TABLE_CONFIG = 6;
var DEVICE_CONFIG = 7;
var ALARM_MONITOR = 8;
var LOG_MONITOR = 9;
var VERSION_MONITOR = 10;
var USER_CONFIG = 11;
var DEFAULT_CONFIG = 12;

var PID_MAP = 13;
var OUT_CONFIG = 14;
var PROGRAM_BACKUP = 15;
var PORT_BACKUP = 16;

var MUX_CONFIG = 19;
var PSI_PREVIEW = 20;
var PSI_INTERVAL = 21;
var CUSTOM_PROGRAM = 22;
var PROGRAM_DETAIL = 23;
var PROGRAM_BACKUP_MUX = 24;
var PSI_EDIT = 25;
var PORT_GENERAL = 34;

var OUTPUT_LIST = 200;
var PID_MAP_LIST = 201;
var PORT_BACKUP_LIST = 202;

var MAIN_GBE_CARD = 6;

var NO_CARD = 7;
var NO_PORT = 7;
var noCardList = ["None", "无卡"];
var noPortList = ["None", "无端口"];

var gbeStrArray = ["GbE", "网口"];
var portStrArray = ["Port", "端口"];

var errorEn = ["",
			   "The number of parameters set is wrong!",
			   "The parameter value is illegal!",
			   "Current user password is error!",
			   "Memory acquisition failure!",
			   "Output PID conflict!",
			   "The service number conflict!",
			   "The input port is a backup port, operation is not allowed!",
			   "The input port is used as muxing, which is not allowed to be set to pass-through!",
			   "The output port is used as muxing, which is not allowed to be set to pass-through!",
			   "EMM which is produced by scrambling is not allowed to delete or modify!",
			   "ECM which is produced by scrambling is not allowed to delete or modify!",
			   "Failed to delete PID because there is a backup service in output programs!",
			   "The input port is pass-through which is not allowed to be set to muxing!",
			   "The input program is used as backup which is not allowed to be set to muxing!",
			   "Failed to modify the output programs which include a backup service!",
			   "Time set error!",
			   "No log!",
			   "Get log overflow!",
			   "Service overflow!",
			   "",
			   "The card does not support port backup!",
			   "The port has been used as a backup port!",
			   "The port backup dose not exist!",
			   "The main port dose not exist!",
			   "The backup port has been used as muxing or pass-through!",
			   "The port backup number reaches the limit!",
			   "The backup mode is error!",
			   "The pass-through set of main and backup is inconsistent!",
			   "",
			   "",
			   "The card does not support service backup!",
			   "The port which is set to program backup has been a backup port for other ports!",
			   "The service backup number reaches the limit!",
			   "The backup service of the port has been used as main or backup!",
			   "The service backup dose not exist!",
			   "The main service of service backup dose not exist!",
			   "The PCR structure is not the same!",
			   "The ECM structure is not the same!",
			   "The main service dose not exist!",
			   "The backup service dose not exist!",
			   "The PID set of the main service and the map is inconsistent!",
			   "The backup service has been used as muxing!",
			   "The bitrate is error!",
			   "The service of main and backup is the same!",
			   "The port of backup service has been used as pass-through!",
			   "",
			   "",
			   "",
			   "",
			   "",
			   "EMM overflow!",
			   "The output port does not have service, EMM is not allowed to be set to muxing!",
			   "PID overflow!",
			   "Stream overflow!",
			   "The output port is pass-through which is not allowed to be set to muxing!",
			   "ID conflict!",
			   "Page has expired, please refresh try it again!",
			   "You can not delete your managed accounts!",
			   "Descriptor overflow!",
			   "Failed to get the page parameter!",
			   "CA descriptor add failed,please add PID mapping firstly!",
			   "PMT PID conflict,please check it!",
			   "Network parameters are conflict with private ip(192.165.53.178/24)!",
			   "Don't allow to reduce the authority directly. If necessary, clear authorization and reboot the device!",
			   "License is illegal!",
			   "Input PID conflict!",
			   "Number of pcr structure adjusted overflow!",
			   "The input port is a loop port, so the operation is not allowed!"];
				
var errorCn = ["",
			   "设置的参数个数错误！",
			   "非法参数值！",
			   "当前用户密码输入错误！",
			   "内存获取失败！",
			   "输出端口PID冲突！",
			   "节目号冲突！",
			   "输入端口是备份端口，操作不允许！",
			   "输入端口已被复用，不允许再设置为透传！",
			   "输出端口已被复用，不允许再设置为透传！",
			   "加扰产生的EMM不允许删除或修改！",
			   "加扰产生的ECM不允许删除或修改！",
			   "PID删除失败，输出节目存在备份节目！",
			   "输入端口已被透传，不允许再设置为复用！",
			   "输入节目已作为备份节目，不允许再设置为复用！",
			   "输出节目存在备份节目，不允许修改！",
			   "时间设置错误！",
			   "无日志信息！",
			   "日志超过最大显示条数！",
			   "节目超过板卡或端口下的最大个数！",
			   "",
			   "板卡不支持端口备份功能！",
			   "设置的端口已经用作备份端口！",
			   "备份关系不存在！",
			   "主路端口不存在！",
			   "备份端口已被复用或透传！",
			   "端口备份个数达到极限！",
			   "设置的备份模式错误！",
			   "主备的透传功能不一致！",
			   "",
			   "",
			   "板卡不支持节目备份功能！",
			   "节目备份的端口是其它端口的备份端口！",
			   "节目备份个数达到极限！",
			   "备路的节目在本端口已用成主路或者备路！",
			   "节目备份关系不存在！",
			   "节目备份的主路节目不存在！",
			   "PCR结构不相同！",
			   "ECM结构不相同！",
			   "搜表结果中没找到主路节目！",
			   "搜表结果中没找到备路节目！",
			   "主路节目的PID和映射表中的PID不一致！",
			   "备路节目已用作该端口内的复用！",
			   "设置的码率错误！",
			   "主路和备路节目相同！",
			   "备路节目所在端口已透传！",
			   "",
			   "",
			   "",
			   "",
			   "",
			   "EMM超过端口下最大支持个数！",
			   "输出端口无节目，不允许复用EMM！",
			   "PID超过节目下最大支持个数！",
			   "传送流超过NIT下最大支持个数！",
			   "输出端口已被透传，不允许再设置为复用！",
			   "ID冲突！",
			   "页面已过期，请刷新后重新操作！",
			   "不能删除自己的管理帐户！",
			   "描述符超过最大支持个数！",
			   "获取页面参数失败！",
			   "CA描述符添加失败，请先添加对应的PID映射！",
			   "存在和PMT PID冲突的PID！",
			   "网络参数与内部IP(192.165.53.178/24)冲突！",
			   "不允许降低授权，如有必要，请先清除授权！",
			   "授权码错误！",
			   "输入端口PID冲突！",
			   "PCR结构调整数目超过最大支持个数！",
			   "输入端口是环入端口，不允许循环复用！"];

var returnError = [errorEn, errorCn];

/*************************************************
Function: 		getPortDisplayStr
Description: 	用于生成显示端口号的文字描述
Input: 			slotNo: 卡号，从0开始;
				portNo: 端口号，从1开始
				language: 1-English; 2-Chinese
Output: 		无
Return: 		显示的字符串
Others: 		无
*************************************************/
function getPortDisplayStr(slotNo, portNo, language)
{
	var displayStr;
	
	if(slotNo == MAIN_GBE_CARD)
	{
		if(portNo <= 256)
		{
			displayStr = gbeStrArray[language] + "1" + portStrArray[language] + portNo;
		}
		else
		{
			displayStr = gbeStrArray[language] + "2" + portStrArray[language] + (portNo - 256);
		}
	}
	else
	{
		displayStr = portStrArray[language] + portNo;
	}
	
	return displayStr;
}


/*************************************************
this only for alarm(including config and monitor)
*************************************************/
var ALARM_CONFIG_TAB = 1;
var ALARM_MONITOR_TAB = 2;

function pageJump(index)
{
	if(index == ALARM_CONFIG_TAB)
	{
		if(language == ENGLISH)
		{
			self.location.replace("alarm_config_en.asp");
		}
		else if(language == CHINESE)
		{
			self.location.replace("alarm_config_cn.asp");
		}
 	}
 	else if(index == ALARM_MONITOR_TAB)
 	{
		if(language == ENGLISH)
		{
			self.location.replace("alarm_monitor_en.asp");
		}
		else if(language == CHINESE)
		{
			self.location.replace("alarm_monitor_cn.asp");
		}
	}
}