var cardTypeEn = ["System", "Card1", "Card2", "Card3", "Card4", "Card5", "Card6", "Main GbE Card"];
var cardTypeCn = ["系统", "卡1", "卡2", "卡3", "卡4", "卡5", "卡6", "主千兆卡"];
var cardType = [cardTypeEn, cardTypeCn];

var logTypeEn = ["Error", "Alarm", "User Operation"];
var logTypeCn = ["错误", "告警", "用户操作"];
var logType = [logTypeEn, logTypeCn];

var ROW_NUM = 20;
var FILTER = 1;
var actionType = 0;

var rowNum;
var totalPage;
var curPage = 1;

var FIRST = 1;
var PREV = 2;
var NEXT = 3;
var LAST = 4;
var PAGE = 5;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	$("#dataTable tr:even").addClass("even_bg_color");
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	
	DisableButton("filterBtn");
	DisableButton("refreshBtn");	
	DisableButton("deleteBtn");
	PageLoadStatus(true);
	displayParam();
	ResetColor();
	EnableButton("filterBtn");
	EnableButton("refreshBtn");
	if(parent.groupAccess == USER)
	{
		DisableButton("deleteBtn");
	}
	else
	{
		EnableButton("deleteBtn");
	}
	PageLoadStatus(false);
}

function getInfo(operation)
{
	switch(operation)
	{
		case FIRST:
			curPage = 1;
			funcUpdateDisplay()
			break;
		case PREV:
			if(curPage > 1)
			{
				curPage--;
			}
			funcUpdateDisplay()
			break;
		case NEXT:
			if(curPage < totalPage)
			{
				curPage++;
			}
			funcUpdateDisplay()
			break;
		case LAST:	
			curPage = totalPage;
			funcUpdateDisplay()
			break;
		case PAGE:
			if(ValidateParam($("#pageNum"), "INT_DEC", 1, totalPage, "<Page Number>", "<页数>", language) == false)
			{
				return;
			}
			curPage = parseInt($("#pageNum").val(), 10);
			funcUpdateDisplay()
			break;
		default:
			break;
	}
}

function filterLog()
{
	actionType = FILTER;
	getInfo(FIRST);
}

function displayParam()
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var startTime = $("#startTime").val();
	var endTime = $("#endTime").val();
	var logType = $("#logType").val();
	var curSlot = $("#curSlot").val();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + LOG_MONITOR + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&curPage=" + curPage + "&startTime=" + startTime + "&endTime=" + endTime + "&logType=" + logType + "&curSlot=" + curSlot + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				if(parseInt(data[length - 1], 10) == 0)
				{
					rowNum = 0;
					totalPage = 0;
				}
				else
				{
					rowNum = length - 1;
					totalPage = parseInt(data[rowNum], 10);
				}
			}
			updateTableData(data);
			refreshFlag = true;
			actionType = 0;
		}	
	}
	xmlHttp.send(null);	
}

function updateTableData(data)
{
	var data;
	var rowData;
	var vTr;
	
	$("#totalPageNum").html(totalPage);
	if(rowNum == 0)
	{
		$("#currentPageNum").html(0);
	}
	else
	{
		$("#currentPageNum").html(curPage);
	}
	if(curPage == 1)
	{
		DisableButton("first", SMALL);
		DisableButton("prev", SMALL);
	}
	else
	{
		EnableButton("first");
		EnableButton("prev");
	}
	if((curPage == totalPage) || (totalPage == 0))
	{
		DisableButton("next", SMALL);
		DisableButton("last", SMALL);
	}
	else
	{
		EnableButton("next");
		EnableButton("last");		
	}
	for(var i = 0; i < rowNum; i++)
	{
		vTr = $("#dataTable").find("tr").eq(i + 1);
		vTr.css("display", "");
		rowData = data[i].split(SECOND_DELIMITER);
		vTr.find("td").eq(0).text(rowData[0]);
		vTr.find("td").eq(1).text(logType[language][parseInt(rowData[1], 10)]);
		vTr.find("td").eq(2).text(cardType[language][parseInt(rowData[2], 10)]);
		vTr.find("td").eq(3).text(rowData[3]);
	}
	for(var i = rowNum ; i < ROW_NUM; i++)
	{
		$("#dataTable").find("tr").eq(i + 1).css("display", "none");
	}
	if(actionType == FILTER)
	{
		if(rowNum != 0)
		{
			if(language == ENGLISH)
			{
				alert("Filter successfully!");
			}
			else
			{
				alert("筛选成功！");
			}
		}
		else
		{
			alert(returnError[language][parseInt(data[0], 10)]);
		}
	}		
}

function deleteLog()
{
	var confirmPrompt;	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all logs?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除所有日志?";
	}
	if(window.confirm(confirmPrompt))
	{
		var data;
		var xmlHttp = GetHTTPObject();
		var response;
	
		data = "type=" + LOG_MONITOR + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("Log delete successfully!");
					}
					else if(language == CHINESE)
					{
						alert("日志删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				getInfo(FIRST);
			}
		}
		xmlHttp.send(data);
	}
}